/* valagenietokentype.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include <vala/valagenietokentype.h>







const char* vala_genie_token_type_to_string (ValaGenieTokenType self) {
	ValaGenieTokenType _tmp134;
	_tmp134 = self;
	if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ABSTRACT)
	do {
		return "`abstract'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ARRAY)
	do {
		return "`array'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_AS)
	do {
		return "`as'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSERT)
	do {
		return "`assert'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN)
	do {
		return "`='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD)
	do {
		return "`+='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND)
	do {
		return "`&='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR)
	do {
		return "`|='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR)
	do {
		return "`^='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV)
	do {
		return "`/='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL)
	do {
		return "`*='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT)
	do {
		return "`%='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT)
	do {
		return "`<<='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB)
	do {
		return "`-='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_BITWISE_AND)
	do {
		return "`&'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_BITWISE_OR)
	do {
		return "`|'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_BREAK)
	do {
		return "`break'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CARRET)
	do {
		return "`^'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CASE)
	do {
		return "`case'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL)
	do {
		return "character literal";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CLASS)
	do {
		return "`class'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE)
	do {
		return "`}'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET)
	do {
		return "`]'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)
	do {
		return "`)'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_COLON)
	do {
		return "`:'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_COMMA)
	do {
		return "`,'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CONST)
	do {
		return "`const'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CONSTRUCT)
	do {
		return "`construct'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_CONTINUE)
	do {
		return "`continue'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DEDENT)
	do {
		return "`dedent'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DEF)
	do {
		return "`def'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DEFAULT)
	do {
		return "`default'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DELEGATE)
	do {
		return "`delegate'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DELETE)
	do {
		return "`delete'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DICT)
	do {
		return "`dict'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DIV)
	do {
		return "`/'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DO)
	do {
		return "`do'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DOT)
	do {
		return "`.'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DOWNTO)
	do {
		return "`downto'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_DYNAMIC)
	do {
		return "`dynamic'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ELLIPSIS)
	do {
		return "`...'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ELSE)
	do {
		return "`else'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ENUM)
	do {
		return "`enum'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ENSURES)
	do {
		return "`ensures'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN)
	do {
		return "`errordomain'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_EOF)
	do {
		return "end of file";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_EOL)
	do {
		return "end of line";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_EVENT)
	do {
		return "event";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_EXCEPT)
	do {
		return "`except'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_EXTERN)
	do {
		return "`extern'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_FALSE)
	do {
		return "`false'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_FINAL)
	do {
		return "`final'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_FINALLY)
	do {
		return "`finally'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_FOR)
	do {
		return "`for'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_FOREACH)
	do {
		return "`foreach'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_GET)
	do {
		return "`get'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_HASH)
	do {
		return "`hash'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_IDENTIFIER)
	do {
		return "identifier";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_IF)
	do {
		return "`if'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_IMPLEMENTS)
	do {
		return "`implements'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_IN)
	do {
		return "`in'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_INDENT)
	do {
		return "`tab indent'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_INIT)
	do {
		return "`init'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_INLINE)
	do {
		return "`inline'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL)
	do {
		return "integer literal";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_INTERFACE)
	do {
		return "`interface'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_INTERR)
	do {
		return "`?'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_IS)
	do {
		return "`is'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_ISA)
	do {
		return "`isa'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_LAMBDA)
	do {
		return "`=>'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_LIST)
	do {
		return "`list'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_LOCK)
	do {
		return "`lock'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_MINUS)
	do {
		return "`-'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_NAMESPACE)
	do {
		return "`namespace'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_NEW)
	do {
		return "`new'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_NULL)
	do {
		return "`null'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OF)
	do {
		return "`of'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OUT)
	do {
		return "`out'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_AND)
	do {
		return "`&&'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_DEC)
	do {
		return "`--'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_EQ)
	do {
		return "`=='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_GE)
	do {
		return "`>='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_GT)
	do {
		return "`>'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_INC)
	do {
		return "`++'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_LE)
	do {
		return "`<='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_LT)
	do {
		return "`<'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_NE)
	do {
		return "`!='";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_NEG)
	do {
		return "`!'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_OR)
	do {
		return "`||'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_PTR)
	do {
		return "`->'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT)
	do {
		return "`<<'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OPEN_BRACE)
	do {
		return "`{'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)
	do {
		return "`['";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)
	do {
		return "`('";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_OVERRIDE)
	do {
		return "`override'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PASS)
	do {
		return "`pass'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PERCENT)
	do {
		return "`%'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PLUS)
	do {
		return "`+'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PRINT)
	do {
		return "`print'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PRIVATE)
	do {
		return "`private'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PROP)
	do {
		return "`prop'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PROTECTED)
	do {
		return "`protected'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_PUBLIC)
	do {
		return "`public'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_RAISE)
	do {
		return "`raise'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_RAISES)
	do {
		return "`raises'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_READONLY)
	do {
		return "`readonly'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_REAL_LITERAL)
	do {
		return "real literal";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_REF)
	do {
		return "`ref'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_REQUIRES)
	do {
		return "`requires'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_RETURN)
	do {
		return "`return'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_SEMICOLON)
	do {
		return "`;'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_SET)
	do {
		return "`set'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_SIZEOF)
	do {
		return "`sizeof'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_STAR)
	do {
		return "`*'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_STATIC)
	do {
		return "`static'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_STRING_LITERAL)
	do {
		return "string literal";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_STRUCT)
	do {
		return "`struct'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_SUPER)
	do {
		return "`super'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_THIS)
	do {
		return "`self'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_TILDE)
	do {
		return "`~'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_TO)
	do {
		return "`to'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_TRUE)
	do {
		return "`true'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_TRY)
	do {
		return "`try'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_TYPEOF)
	do {
		return "`typeof'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_USES)
	do {
		return "`uses'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_VAR)
	do {
		return "`var'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_VIRTUAL)
	do {
		return "`virtual'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_VOID)
	do {
		return "`void'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_VOLATILE)
	do {
		return "`volatile'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_WEAK)
	do {
		return "`weak'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_WHEN)
	do {
		return "`when'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_WHILE)
	do {
		return "`while'";
	} while (0); else if (_tmp134 == VALA_GENIE_TOKEN_TYPE_WRITEONLY)
	do {
		return "`writeonly'";
	} while (0); else
	do {
		return "unknown token";
	} while (0);
}



GType vala_genie_token_type_get_type (void) {
	static GType vala_genie_token_type_type_id = 0;
	if (G_UNLIKELY (vala_genie_token_type_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_GENIE_TOKEN_TYPE_NONE, "VALA_GENIE_TOKEN_TYPE_NONE", "none"}, {VALA_GENIE_TOKEN_TYPE_ABSTRACT, "VALA_GENIE_TOKEN_TYPE_ABSTRACT", "abstract"}, {VALA_GENIE_TOKEN_TYPE_ARRAY, "VALA_GENIE_TOKEN_TYPE_ARRAY", "array"}, {VALA_GENIE_TOKEN_TYPE_AS, "VALA_GENIE_TOKEN_TYPE_AS", "as"}, {VALA_GENIE_TOKEN_TYPE_ASSERT, "VALA_GENIE_TOKEN_TYPE_ASSERT", "assert"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN, "VALA_GENIE_TOKEN_TYPE_ASSIGN", "assign"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD, "VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD", "assign-add"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND, "VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND", "assign-bitwise-and"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR, "VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR", "assign-bitwise-or"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR, "VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR", "assign-bitwise-xor"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV, "VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV", "assign-div"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL, "VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL", "assign-mul"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT, "VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT", "assign-percent"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT, "VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT", "assign-shift-left"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB, "VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB", "assign-sub"}, {VALA_GENIE_TOKEN_TYPE_BITWISE_AND, "VALA_GENIE_TOKEN_TYPE_BITWISE_AND", "bitwise-and"}, {VALA_GENIE_TOKEN_TYPE_BITWISE_OR, "VALA_GENIE_TOKEN_TYPE_BITWISE_OR", "bitwise-or"}, {VALA_GENIE_TOKEN_TYPE_BREAK, "VALA_GENIE_TOKEN_TYPE_BREAK", "break"}, {VALA_GENIE_TOKEN_TYPE_CARRET, "VALA_GENIE_TOKEN_TYPE_CARRET", "carret"}, {VALA_GENIE_TOKEN_TYPE_CASE, "VALA_GENIE_TOKEN_TYPE_CASE", "case"}, {VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL, "VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL", "character-literal"}, {VALA_GENIE_TOKEN_TYPE_CLASS, "VALA_GENIE_TOKEN_TYPE_CLASS", "class"}, {VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, "VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, "VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, "VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {VALA_GENIE_TOKEN_TYPE_COLON, "VALA_GENIE_TOKEN_TYPE_COLON", "colon"}, {VALA_GENIE_TOKEN_TYPE_COMMA, "VALA_GENIE_TOKEN_TYPE_COMMA", "comma"}, {VALA_GENIE_TOKEN_TYPE_CONST, "VALA_GENIE_TOKEN_TYPE_CONST", "const"}, {VALA_GENIE_TOKEN_TYPE_CONSTRUCT, "VALA_GENIE_TOKEN_TYPE_CONSTRUCT", "construct"}, {VALA_GENIE_TOKEN_TYPE_CONTINUE, "VALA_GENIE_TOKEN_TYPE_CONTINUE", "continue"}, {VALA_GENIE_TOKEN_TYPE_DEDENT, "VALA_GENIE_TOKEN_TYPE_DEDENT", "dedent"}, {VALA_GENIE_TOKEN_TYPE_DEF, "VALA_GENIE_TOKEN_TYPE_DEF", "def"}, {VALA_GENIE_TOKEN_TYPE_DEFAULT, "VALA_GENIE_TOKEN_TYPE_DEFAULT", "default"}, {VALA_GENIE_TOKEN_TYPE_DELEGATE, "VALA_GENIE_TOKEN_TYPE_DELEGATE", "delegate"}, {VALA_GENIE_TOKEN_TYPE_DELETE, "VALA_GENIE_TOKEN_TYPE_DELETE", "delete"}, {VALA_GENIE_TOKEN_TYPE_DICT, "VALA_GENIE_TOKEN_TYPE_DICT", "dict"}, {VALA_GENIE_TOKEN_TYPE_DIV, "VALA_GENIE_TOKEN_TYPE_DIV", "div"}, {VALA_GENIE_TOKEN_TYPE_DO, "VALA_GENIE_TOKEN_TYPE_DO", "do"}, {VALA_GENIE_TOKEN_TYPE_DOT, "VALA_GENIE_TOKEN_TYPE_DOT", "dot"}, {VALA_GENIE_TOKEN_TYPE_DOWNTO, "VALA_GENIE_TOKEN_TYPE_DOWNTO", "downto"}, {VALA_GENIE_TOKEN_TYPE_DYNAMIC, "VALA_GENIE_TOKEN_TYPE_DYNAMIC", "dynamic"}, {VALA_GENIE_TOKEN_TYPE_ELLIPSIS, "VALA_GENIE_TOKEN_TYPE_ELLIPSIS", "ellipsis"}, {VALA_GENIE_TOKEN_TYPE_ELSE, "VALA_GENIE_TOKEN_TYPE_ELSE", "else"}, {VALA_GENIE_TOKEN_TYPE_ENUM, "VALA_GENIE_TOKEN_TYPE_ENUM", "enum"}, {VALA_GENIE_TOKEN_TYPE_ENSURES, "VALA_GENIE_TOKEN_TYPE_ENSURES", "ensures"}, {VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN, "VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GENIE_TOKEN_TYPE_EOF, "VALA_GENIE_TOKEN_TYPE_EOF", "eof"}, {VALA_GENIE_TOKEN_TYPE_EOL, "VALA_GENIE_TOKEN_TYPE_EOL", "eol"}, {VALA_GENIE_TOKEN_TYPE_EVENT, "VALA_GENIE_TOKEN_TYPE_EVENT", "event"}, {VALA_GENIE_TOKEN_TYPE_EXCEPT, "VALA_GENIE_TOKEN_TYPE_EXCEPT", "except"}, {VALA_GENIE_TOKEN_TYPE_EXTERN, "VALA_GENIE_TOKEN_TYPE_EXTERN", "extern"}, {VALA_GENIE_TOKEN_TYPE_FALSE, "VALA_GENIE_TOKEN_TYPE_FALSE", "false"}, {VALA_GENIE_TOKEN_TYPE_FINAL, "VALA_GENIE_TOKEN_TYPE_FINAL", "final"}, {VALA_GENIE_TOKEN_TYPE_FINALLY, "VALA_GENIE_TOKEN_TYPE_FINALLY", "finally"}, {VALA_GENIE_TOKEN_TYPE_FOR, "VALA_GENIE_TOKEN_TYPE_FOR", "for"}, {VALA_GENIE_TOKEN_TYPE_FOREACH, "VALA_GENIE_TOKEN_TYPE_FOREACH", "foreach"}, {VALA_GENIE_TOKEN_TYPE_GET, "VALA_GENIE_TOKEN_TYPE_GET", "get"}, {VALA_GENIE_TOKEN_TYPE_HASH, "VALA_GENIE_TOKEN_TYPE_HASH", "hash"}, {VALA_GENIE_TOKEN_TYPE_IDENTIFIER, "VALA_GENIE_TOKEN_TYPE_IDENTIFIER", "identifier"}, {VALA_GENIE_TOKEN_TYPE_IF, "VALA_GENIE_TOKEN_TYPE_IF", "if"}, {VALA_GENIE_TOKEN_TYPE_IMPLEMENTS, "VALA_GENIE_TOKEN_TYPE_IMPLEMENTS", "implements"}, {VALA_GENIE_TOKEN_TYPE_IN, "VALA_GENIE_TOKEN_TYPE_IN", "in"}, {VALA_GENIE_TOKEN_TYPE_INDENT, "VALA_GENIE_TOKEN_TYPE_INDENT", "indent"}, {VALA_GENIE_TOKEN_TYPE_INIT, "VALA_GENIE_TOKEN_TYPE_INIT", "init"}, {VALA_GENIE_TOKEN_TYPE_INLINE, "VALA_GENIE_TOKEN_TYPE_INLINE", "inline"}, {VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL, "VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL", "integer-literal"}, {VALA_GENIE_TOKEN_TYPE_INTERFACE, "VALA_GENIE_TOKEN_TYPE_INTERFACE", "interface"}, {VALA_GENIE_TOKEN_TYPE_INTERR, "VALA_GENIE_TOKEN_TYPE_INTERR", "interr"}, {VALA_GENIE_TOKEN_TYPE_IS, "VALA_GENIE_TOKEN_TYPE_IS", "is"}, {VALA_GENIE_TOKEN_TYPE_ISA, "VALA_GENIE_TOKEN_TYPE_ISA", "isa"}, {VALA_GENIE_TOKEN_TYPE_LAMBDA, "VALA_GENIE_TOKEN_TYPE_LAMBDA", "lambda"}, {VALA_GENIE_TOKEN_TYPE_LIST, "VALA_GENIE_TOKEN_TYPE_LIST", "list"}, {VALA_GENIE_TOKEN_TYPE_LOCK, "VALA_GENIE_TOKEN_TYPE_LOCK", "lock"}, {VALA_GENIE_TOKEN_TYPE_MINUS, "VALA_GENIE_TOKEN_TYPE_MINUS", "minus"}, {VALA_GENIE_TOKEN_TYPE_NAMESPACE, "VALA_GENIE_TOKEN_TYPE_NAMESPACE", "namespace"}, {VALA_GENIE_TOKEN_TYPE_NEW, "VALA_GENIE_TOKEN_TYPE_NEW", "new"}, {VALA_GENIE_TOKEN_TYPE_NULL, "VALA_GENIE_TOKEN_TYPE_NULL", "null"}, {VALA_GENIE_TOKEN_TYPE_OF, "VALA_GENIE_TOKEN_TYPE_OF", "of"}, {VALA_GENIE_TOKEN_TYPE_OUT, "VALA_GENIE_TOKEN_TYPE_OUT", "out"}, {VALA_GENIE_TOKEN_TYPE_OP_AND, "VALA_GENIE_TOKEN_TYPE_OP_AND", "op-and"}, {VALA_GENIE_TOKEN_TYPE_OP_DEC, "VALA_GENIE_TOKEN_TYPE_OP_DEC", "op-dec"}, {VALA_GENIE_TOKEN_TYPE_OP_EQ, "VALA_GENIE_TOKEN_TYPE_OP_EQ", "op-eq"}, {VALA_GENIE_TOKEN_TYPE_OP_GE, "VALA_GENIE_TOKEN_TYPE_OP_GE", "op-ge"}, {VALA_GENIE_TOKEN_TYPE_OP_GT, "VALA_GENIE_TOKEN_TYPE_OP_GT", "op-gt"}, {VALA_GENIE_TOKEN_TYPE_OP_INC, "VALA_GENIE_TOKEN_TYPE_OP_INC", "op-inc"}, {VALA_GENIE_TOKEN_TYPE_OP_LE, "VALA_GENIE_TOKEN_TYPE_OP_LE", "op-le"}, {VALA_GENIE_TOKEN_TYPE_OP_LT, "VALA_GENIE_TOKEN_TYPE_OP_LT", "op-lt"}, {VALA_GENIE_TOKEN_TYPE_OP_NE, "VALA_GENIE_TOKEN_TYPE_OP_NE", "op-ne"}, {VALA_GENIE_TOKEN_TYPE_OP_NEG, "VALA_GENIE_TOKEN_TYPE_OP_NEG", "op-neg"}, {VALA_GENIE_TOKEN_TYPE_OP_OR, "VALA_GENIE_TOKEN_TYPE_OP_OR", "op-or"}, {VALA_GENIE_TOKEN_TYPE_OP_PTR, "VALA_GENIE_TOKEN_TYPE_OP_PTR", "op-ptr"}, {VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT, "VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT", "op-shift-left"}, {VALA_GENIE_TOKEN_TYPE_OPEN_BRACE, "VALA_GENIE_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET, "VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, "VALA_GENIE_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {VALA_GENIE_TOKEN_TYPE_OVERRIDE, "VALA_GENIE_TOKEN_TYPE_OVERRIDE", "override"}, {VALA_GENIE_TOKEN_TYPE_PASS, "VALA_GENIE_TOKEN_TYPE_PASS", "pass"}, {VALA_GENIE_TOKEN_TYPE_PERCENT, "VALA_GENIE_TOKEN_TYPE_PERCENT", "percent"}, {VALA_GENIE_TOKEN_TYPE_PLUS, "VALA_GENIE_TOKEN_TYPE_PLUS", "plus"}, {VALA_GENIE_TOKEN_TYPE_PRINT, "VALA_GENIE_TOKEN_TYPE_PRINT", "print"}, {VALA_GENIE_TOKEN_TYPE_PRIVATE, "VALA_GENIE_TOKEN_TYPE_PRIVATE", "private"}, {VALA_GENIE_TOKEN_TYPE_PROP, "VALA_GENIE_TOKEN_TYPE_PROP", "prop"}, {VALA_GENIE_TOKEN_TYPE_PROTECTED, "VALA_GENIE_TOKEN_TYPE_PROTECTED", "protected"}, {VALA_GENIE_TOKEN_TYPE_PUBLIC, "VALA_GENIE_TOKEN_TYPE_PUBLIC", "public"}, {VALA_GENIE_TOKEN_TYPE_RAISE, "VALA_GENIE_TOKEN_TYPE_RAISE", "raise"}, {VALA_GENIE_TOKEN_TYPE_RAISES, "VALA_GENIE_TOKEN_TYPE_RAISES", "raises"}, {VALA_GENIE_TOKEN_TYPE_REAL_LITERAL, "VALA_GENIE_TOKEN_TYPE_REAL_LITERAL", "real-literal"}, {VALA_GENIE_TOKEN_TYPE_READONLY, "VALA_GENIE_TOKEN_TYPE_READONLY", "readonly"}, {VALA_GENIE_TOKEN_TYPE_REF, "VALA_GENIE_TOKEN_TYPE_REF", "ref"}, {VALA_GENIE_TOKEN_TYPE_REQUIRES, "VALA_GENIE_TOKEN_TYPE_REQUIRES", "requires"}, {VALA_GENIE_TOKEN_TYPE_RETURN, "VALA_GENIE_TOKEN_TYPE_RETURN", "return"}, {VALA_GENIE_TOKEN_TYPE_SEMICOLON, "VALA_GENIE_TOKEN_TYPE_SEMICOLON", "semicolon"}, {VALA_GENIE_TOKEN_TYPE_SET, "VALA_GENIE_TOKEN_TYPE_SET", "set"}, {VALA_GENIE_TOKEN_TYPE_SIZEOF, "VALA_GENIE_TOKEN_TYPE_SIZEOF", "sizeof"}, {VALA_GENIE_TOKEN_TYPE_STAR, "VALA_GENIE_TOKEN_TYPE_STAR", "star"}, {VALA_GENIE_TOKEN_TYPE_STATIC, "VALA_GENIE_TOKEN_TYPE_STATIC", "static"}, {VALA_GENIE_TOKEN_TYPE_STRING_LITERAL, "VALA_GENIE_TOKEN_TYPE_STRING_LITERAL", "string-literal"}, {VALA_GENIE_TOKEN_TYPE_STRUCT, "VALA_GENIE_TOKEN_TYPE_STRUCT", "struct"}, {VALA_GENIE_TOKEN_TYPE_SUPER, "VALA_GENIE_TOKEN_TYPE_SUPER", "super"}, {VALA_GENIE_TOKEN_TYPE_THIS, "VALA_GENIE_TOKEN_TYPE_THIS", "this"}, {VALA_GENIE_TOKEN_TYPE_TILDE, "VALA_GENIE_TOKEN_TYPE_TILDE", "tilde"}, {VALA_GENIE_TOKEN_TYPE_TO, "VALA_GENIE_TOKEN_TYPE_TO", "to"}, {VALA_GENIE_TOKEN_TYPE_TRUE, "VALA_GENIE_TOKEN_TYPE_TRUE", "true"}, {VALA_GENIE_TOKEN_TYPE_TRY, "VALA_GENIE_TOKEN_TYPE_TRY", "try"}, {VALA_GENIE_TOKEN_TYPE_TYPEOF, "VALA_GENIE_TOKEN_TYPE_TYPEOF", "typeof"}, {VALA_GENIE_TOKEN_TYPE_USES, "VALA_GENIE_TOKEN_TYPE_USES", "uses"}, {VALA_GENIE_TOKEN_TYPE_VAR, "VALA_GENIE_TOKEN_TYPE_VAR", "var"}, {VALA_GENIE_TOKEN_TYPE_VIRTUAL, "VALA_GENIE_TOKEN_TYPE_VIRTUAL", "virtual"}, {VALA_GENIE_TOKEN_TYPE_VOID, "VALA_GENIE_TOKEN_TYPE_VOID", "void"}, {VALA_GENIE_TOKEN_TYPE_VOLATILE, "VALA_GENIE_TOKEN_TYPE_VOLATILE", "volatile"}, {VALA_GENIE_TOKEN_TYPE_WEAK, "VALA_GENIE_TOKEN_TYPE_WEAK", "weak"}, {VALA_GENIE_TOKEN_TYPE_WHEN, "VALA_GENIE_TOKEN_TYPE_WHEN", "when"}, {VALA_GENIE_TOKEN_TYPE_WHILE, "VALA_GENIE_TOKEN_TYPE_WHILE", "while"}, {VALA_GENIE_TOKEN_TYPE_WRITEONLY, "VALA_GENIE_TOKEN_TYPE_WRITEONLY", "writeonly"}, {0, NULL, NULL}};
		vala_genie_token_type_type_id = g_enum_register_static ("ValaGenieTokenType", values);
	}
	return vala_genie_token_type_type_id;
}




