/* valaccodeinterfacebinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEINTERFACEBINDING_H__
#define __GOBJECT_VALACCODEINTERFACEBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valainterface.h>
#include <gobject/valaccodeobjecttypesymbolbinding.h>
#include <gobject/valaccodegenerator.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_INTERFACE_BINDING (vala_ccode_interface_binding_get_type ())
#define VALA_CCODE_INTERFACE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INTERFACE_BINDING, ValaCCodeInterfaceBinding))
#define VALA_CCODE_INTERFACE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INTERFACE_BINDING, ValaCCodeInterfaceBindingClass))
#define VALA_IS_CCODE_INTERFACE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INTERFACE_BINDING))
#define VALA_IS_CCODE_INTERFACE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INTERFACE_BINDING))
#define VALA_CCODE_INTERFACE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INTERFACE_BINDING, ValaCCodeInterfaceBindingClass))

typedef struct _ValaCCodeInterfaceBinding ValaCCodeInterfaceBinding;
typedef struct _ValaCCodeInterfaceBindingClass ValaCCodeInterfaceBindingClass;
typedef struct _ValaCCodeInterfaceBindingPrivate ValaCCodeInterfaceBindingPrivate;

struct _ValaCCodeInterfaceBinding {
	ValaCCodeObjectTypeSymbolBinding parent_instance;
	ValaCCodeInterfaceBindingPrivate * priv;
};

struct _ValaCCodeInterfaceBindingClass {
	ValaCCodeObjectTypeSymbolBindingClass parent_class;
};


ValaCCodeInterfaceBinding* vala_ccode_interface_binding_new (ValaCCodeGenerator* codegen, ValaInterface* iface);
ValaInterface* vala_ccode_interface_binding_get_iface (ValaCCodeInterfaceBinding* self);
void vala_ccode_interface_binding_set_iface (ValaCCodeInterfaceBinding* self, ValaInterface* value);
GType vala_ccode_interface_binding_get_type (void);


G_END_DECLS

#endif
