/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse mèl :
	BILLARD, non joignable par mèl ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est régi par la licence CeCILL soumise au droit français et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accepté les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef INTERACTIVE_H
#define INTERACTIVE_H

#include <glib.h>

#include "view.h"
#include <visu_nodes.h>
#include <visu_data.h>
#include <visu_pickMesure.h>
#include <renderingBackend/visu_actionInterface.h>

/**
 * OPENGL_OBSERVE_CONSTRAINED
 *
 * This is a key for the constrained mode in the observe session.
 * In this mode, the movements are along meridians when the mouse is
 * dragged along y axis and along parallels when the movement is along x axis.
 */
/**
 * OPENGL_OBSERVE_WALKER
 *
 * This is a key for the constrained mode in the observe session.
 * In this mode, the movementsare those of a walking ant on a sphere,
 * when mouse move along y axis, the ant goes strait on, when mouse is
 * dragged along x axis, the ant translates on its right or on its left.
 */
typedef enum
  {
    interactive_constrained,
    interactive_walker
  } VisuInteractiveMethod;

typedef enum
  {
    interactive_none,
    interactive_observe,
    interactive_pickAndObserve,
    interactive_pick,
    interactive_move,
    interactive_mark
  } VisuInteractiveId;

/**
 * VISU_INTERACTIVE_TYPE:
 *
 * return the type of #VisuInteractive.
 */
#define VISU_INTERACTIVE_TYPE	     (visuInteractive_get_type ())
/**
 * VISU_INTERACTIVE:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuInteractive type.
 */
#define VISU_INTERACTIVE(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, VISU_INTERACTIVE_TYPE, VisuInteractive))
/**
 * VISU_INTERACTIVE_CLASS:
 * @klass: a #GClassObject to cast.
 *
 * Cast the given @klass into #VisuInteractiveClass.
 */
#define VISU_INTERACTIVE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, VISU_INTERACTIVE_TYPE, VisuInteractiveClass))
/**
 * IS_VISU_INTERACTIVE_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuInteractive object.
 */
#define IS_VISU_INTERACTIVE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, VISU_INTERACTIVE_TYPE))
/**
 * IS_VISU_INTERACTIVE_CLASS:
 * @klass: a #GClassObject to test.
 *
 * Test if the given @klass is of the type of #VisuInteractiveClass class.
 */
#define IS_VISU_INTERACTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, VISU_INTERACTIVE_TYPE))
/**
 * VISU_INTERACTIVE_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define VISU_INTERACTIVE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, VISU_INTERACTIVE_TYPE, VisuInteractiveClass))

/**
 * VisuInteractive:
 *
 * All fields are private.
 */
typedef struct _VisuInteractive VisuInteractive;
typedef struct _VisuInteractiveClass VisuInteractiveClass;

/**
 * visu_interactive_get_type:
 *
 * This method returns the type of #VisuInteractive, use VISU_INTERACTIVE_TYPE instead.
 *
 * Returns: the type of #VisuInteractive.
 */
GType visuInteractive_get_type(void);

/**
 * openGLInteractiveSet_preferedObserveMethod:
 * @method: an integer that identify the method, see #OPENGL_OBSERVE_CONSTRAINED,
 *          and #OPENGL_OBSERVE_WALKER flags.
 *
 * There are two methods to move the camera in a pick and observe sesion. These
 * two methods are described in the commentary of the keys #OPENGL_OBSERVE_CONSTRAINED
 * an d#OPENGL_OBSERVE_WALKER.
 */
void visuInteractiveClassSet_preferedObserveMethod(VisuInteractiveMethod method);
/**
 * openGLInteractiveGet_preferedObserveMethod:
 *
 * There are two methods to move the camera in a pick and observe sesion. These
 * two methods are described in the commentary of the keys #OPENGL_OBSERVE_CONSTRAINED
 * an d#OPENGL_OBSERVE_WALKER.
 *
 * Returns: an integer that identify the method, see #OPENGL_OBSERVE_CONSTRAINED,
 *          and #OPENGL_OBSERVE_WALKER flags.
 */
VisuInteractiveMethod visuInteractiveClassGet_preferedObserveMethod();

/**
 * openGLInteractiveInit_session:
 * @window: a pointer to the window that ask to initialize
 *          an interactive mode ;
 * @handler: a pointer to a method to be called whenever
 *           an element is selected (can be NULL) ;
 * @data: a location for user data that can be given to handler ;
 * @stopPickObserve: a pointer to a method that will be called
 *                   every time a pick or an observe session are
 *                   finish (can be NULL).
 *
 * Initialises a period when the client can control an interactive session
 * (observe, pick, move...). It changes cursors shapes and initialises different
 * internal variables. It can be stop by a call to openGLInteractiveEnd_session().
 * The default first interactive session is an observe session.
 *
 * Returns: a newly created object. This object is automatically
 * associated to the #VisuData handled by the @window and will be
 * destroyed with it.
 */
VisuInteractive* visuInteractiveNew(GenericRenderingWindow window);

/**
 * openGLInteractiveBegin_observe:
 * @inter: a #VisuInteractive object.
 * 
 * During a pick or observe session, the client can begin an observe session
 * by a call to this method. It actually stops also a possibly running
 * pick session.
 */
void visuInteractiveSet_type(VisuInteractive *inter, VisuInteractiveId type);

/**
 * openGLInteractiveHandle_event:
 * @ev: an event ;
 * @inter: a #VisuInteractive object.
 *
 * This routine should be called by the rendering window when some
 * event is raised on the rendering surface.
 */
void visuInteractiveHandle_event(VisuInteractive *inter, SimplifiedEvents *ev);

/**
 * openGLInteractiveStart_move:
 * @inter: a #VisuInteractive object ;
 * @nodes: a list of #VisuNode (not ids).
 *
 * Update the internal of @inter when the given list is dragged. This
 * means to create a new list with the given nodes and remove them
 * from the classical #VisuData OpenGL lists. A redraw is
 * automatically asked.
 */
void visuInteractiveStart_move(VisuInteractive *inter, GList *nodes);
/**
 * openGLInteractiveStop_move:
 * @inter: a #VisuInteractive object ;
 * @nodes: a list of #VisuNode (not ids).
 *
 * Update the internal of @inter when the drag stops. The @nodes are
 * recreated in the OpenGL lists of #VisuData. A redraw is
 * automatically asked.
 */
void visuInteractiveStop_move(VisuInteractive *inter, GList *nodes);
/**
 * openGLInteractiveMove:
 * @inter: a #VisuInteractive object ;
 * @nodes: a list of #VisuNode ids ;
 * @drag: a translation (in cartesian coordinates).
 *
 * Update the internal of @inter when the given list is dragged.
 */
void visuInteractiveMove(VisuInteractive *inter, GList *nodes, float drag[3]);

/**
 * openGLInteractiveGet_pickMesure:
 * @inter: a #VisuInteractive object.
 * 
 * Get the #PickMesure object associated to an interactive session.
 *
 * Returns: a #PickMesure object, private.
 */
PickMesure* visuInteractiveGet_pickMesure(VisuInteractive *inter);
/**
 * openGLInteractiveSet_visuData:
 * @inter: a #VisuInteractive object ;
 * @data: a #VisuData object.
 *
 * Change the #VisuData the interactive session is dealing with.
 */
void visuInteractiveSet_visuData(VisuInteractive *inter, VisuData *data);

OpenGLCamera* visuInteractivePop_savedCamera(VisuInteractive *inter);
void visuInteractivePush_savedCamera(VisuInteractive *inter, OpenGLCamera *camera);
void visuInteractiveGet_savedCameras(VisuInteractive *inter,
				       GList **cameras, GList **head);

/**
 * getNodes2DCoordinates:
 * @dataObj: a #VisuData object ;
 * nodeIds: an array of #VisuNode ids ;
 * nNodes: the number of nodes in the array ;
 * coordinates2D: an array of nodes 2D coordinates ;
 * size: the size of the coordinates array.
 *
 * From nodes ids, compute and store in @coordinates2D their 2D coordinates.
 */
void getNodes2DCoordinates(VisuData *dataObj, unsigned int *nodeIds,
	unsigned int nNodes, float *coordinates2D, unsigned int *size);

void defineNodeVertices(int nVert, double radius, double xn, double yn, double *nodeVertices);

void addVerticesToGlobalArray(int nVert, double *nodeVertices, double *vertices, int i);

#endif
