/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "gtk_cylinder.h"

#include <gtk/gtk.h>
#include <support.h>

#include <visu_object.h>
#include <visu_tools.h>
#include <gtk_pairs.h>

#include "cylinder.h"

int colorForCurve;
int colorDescr;

GtkWidget *spinCylinderRadius;
gulong signalSpinCylinderRadiusId;
GtkWidget *radioCylinderUser, *radioCylinderElement;

#define RESOURCES_CYLINDER_RADIUS_STEP 0.02

/* Callbacks */
void changeCylinderRadius(GtkSpinButton *spin, gpointer data);
void changeCylinderColorType(GtkToggleButton *button, gpointer data);
/* static void cylinderValuesChangedOnResources(GObject *obj, gpointer data); */

void gtkPairsCylinderInit(void)
{
/*   g_signal_connect(G_OBJECT(visu), "resourcesLoaded", */
/* 		   G_CALLBACK(cylinderValuesChangedOnResources), (gpointer)0); */
}


GtkWidget* gtkPairsCylinderBuild_widgets()
{
  GtkWidget *hbox1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *alignment1;
  GtkObject *spinCylinderRadius_adj;
  GtkWidget *vseparator1;
  GtkWidget *vbox2;
  GtkWidget *label2;
  GtkWidget *alignment2;
  GtkWidget *hbox2;
  GSList *radioCylinderUser_group = NULL;

  hbox1 = gtk_hbox_new (FALSE, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, FALSE, FALSE, 0);

  label1 = gtk_label_new (_("Radius:"));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  alignment1 = gtk_alignment_new (1, 0.5, 0, 1);
  gtk_widget_show (alignment1);
  gtk_box_pack_start (GTK_BOX (vbox1), alignment1, FALSE, FALSE, 0);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 15, 0);

  spinCylinderRadius_adj = gtk_adjustment_new (getCylinderGeneralRadius(),
					RESOURCES_CYLINDER_RADIUS_MIN,
					RESOURCES_CYLINDER_RADIUS_MAX,
					RESOURCES_CYLINDER_RADIUS_STEP,
					RESOURCES_CYLINDER_RADIUS_STEP * 5., 0);
  spinCylinderRadius = gtk_spin_button_new (GTK_ADJUSTMENT (spinCylinderRadius_adj), 1, 2);
  gtk_widget_show (spinCylinderRadius);
  gtk_container_add (GTK_CONTAINER (alignment1), spinCylinderRadius);

  vseparator1 = gtk_vseparator_new ();
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox1), vseparator1, FALSE, FALSE, 4);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);

  label2 = gtk_label_new (_("Use color scheme:"));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  alignment2 = gtk_alignment_new (1, 0.5, 0, 1);
  gtk_widget_show (alignment2);
  gtk_box_pack_start (GTK_BOX (vbox2), alignment2, FALSE, FALSE, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox2);

  radioCylinderUser = gtk_radio_button_new_with_mnemonic (NULL, _("User defined"));
  gtk_widget_set_name(radioCylinderUser, "message_radio");
  gtk_widget_show (radioCylinderUser);
  gtk_box_pack_start (GTK_BOX (hbox2), radioCylinderUser, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radioCylinderUser), radioCylinderUser_group);
  radioCylinderUser_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radioCylinderUser));
  if (getCylinderColorType() == 0)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioCylinderUser), TRUE);

  radioCylinderElement = gtk_radio_button_new_with_mnemonic (NULL, _("Follow elements"));
  gtk_widget_set_name(radioCylinderElement, "message_radio");
  gtk_widget_show (radioCylinderElement);
  gtk_box_pack_start (GTK_BOX (hbox2), radioCylinderElement, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radioCylinderElement), radioCylinderUser_group);
  radioCylinderUser_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radioCylinderElement));
  if (getCylinderColorType() == 1)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioCylinderElement), TRUE);

  signalSpinCylinderRadiusId = g_signal_connect(G_OBJECT(spinCylinderRadius), "value-changed",
						G_CALLBACK(changeCylinderRadius), (gpointer)0);

  g_signal_connect(G_OBJECT(radioCylinderUser), "toggled",
		   G_CALLBACK(changeCylinderColorType), GINT_TO_POINTER(0));
  g_signal_connect(G_OBJECT(radioCylinderElement), "toggled",
		   G_CALLBACK(changeCylinderColorType), GINT_TO_POINTER(1));

  return hbox1;
}

void changeCylinderRadius(GtkSpinButton *spin, gpointer data _U_)
{
  int res;
  GtkPairsIter iter;
  gchar* label;

  res = FALSE;
  /* Currently, the label depends only on the radius, so
     we can build only one label and use it every time. */
  label = (gchar*)0;
  /* We run on all selected pairs. */
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
      /* We change the value for this pair. */
      res = setCylinderRadius(iter.data,
			      (float)gtk_spin_button_get_value(spin)) || res;
      if (!label)
	label = gtkPairsCylinderGet_valuesAsLabel(iter.data);
      /* We change the drawn label. */
      gtkPairsSet_specificLabels(&(iter.iter), label);
    }
  g_free(label);

  if (res)
    gtkPairs_createPairs();
}

void changeCylinderColorType(GtkToggleButton *button, gpointer data)
{
  int color;
  int res;

  if (!gtk_toggle_button_get_active(button))
    return;
  
  color = GPOINTER_TO_INT(data);
  g_return_if_fail(color >= 0 && color < cylinder_nb_color);

  res = setCylinderColorType(color);
  if (res)
    gtkPairs_createPairs();
}

/* static void cylinderValuesChangedOnResources(GObject *obj, gpointer data) */
/* { */
/*   int val; */

/*   if (!gtkPairs_isPairExtensionInUse(pointerToPairExtension_cylinder)) */
/*     return; */

/*   DBG_fprintf(stderr, "Gtk Cylinder : catch the 'resourcesLoaded' signal, updating values.\n"); */
/*   gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinCylinderRadius), getCylinderGeneralRadius()); */
/*   val = getCylinderColorType(); */
/*   switch (val) */
/*     { */
/*     case cylinder_user_color: */
/*       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioCylinderUser), TRUE); */
/*       break; */
/*     case cylinder_element_color: */
/*       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioCylinderElement), TRUE); */
/*       break; */
/*     } */
/* } */

void gtkPairsCylinderSet_values(VisuPairData *data)
{
  float *radius;
  float val;

  radius = (float*)visuPairGet_linkProperty(data, "radius");
  if (radius)
    val = *radius;
  else
    val = getCylinderGeneralRadius();

  g_signal_handler_block(G_OBJECT(spinCylinderRadius), signalSpinCylinderRadiusId);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinCylinderRadius), val);
  g_signal_handler_unblock(G_OBJECT(spinCylinderRadius), signalSpinCylinderRadiusId);
}

gchar* gtkPairsCylinderGet_valuesAsLabel(VisuPairData *data)
{
  gchar *str;
  float *radius;
  float val;

  radius = (float*)visuPairGet_linkProperty(data, "radius");
  if (radius)
    val = *radius;
  else
    val = getCylinderGeneralRadius();

  /* a.u. is for arbitrary units. */
  str = g_strdup_printf("%3.2f%s", val, _("a.u."));

  return str;
}
