/* ========================================================================== */
/* === umfpack_free_symbolic ================================================ */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

void umfpack_free_symbolic
(
    void **Symbolic
) ;

void umfpack_l_free_symbolic
(
    void **Symbolic
) ;

/*
int Syntax:

    #include "umfpack.h"
    void *Symbolic ;
    umfpack_free_symbolic (&Symbolic) ;

long Syntax:

    #include "umfpack.h"
    void *Symbolic ;
    umfpack_l_free_symbolic (&Symbolic) ;

Purpose:

    Deallocates the Symbolic object and sets the Symbolic handle to NULL.
    This routine is the only valid way of destroying the Symbolic object;
    any other action (such as using "free (Symbolic) ;" or not freeing Symbolic
    at all) will lead to memory leaks.

Arguments:

    void **Symbolic ;		Input argument, deallocated and Symbolic is
				set to (void *) NULL on output.

	Symbolic must point to a valid Symbolic object, computed by
	umfpack_symbolic.  No action is taken if Symbolic is a (void *) NULL
	pointer.

*/

