/* ========================================================================== */
/* === umfpack_col_to_triplet =============================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_col_to_triplet
(
    int n,
    const int Ap [ ],
    int Tj [ ]
) ;

long umfpack_l_col_to_triplet
(
    long n,
    const long Ap [ ],
    long Tj [ ]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, *Tj, *Ap, status ;
    status = umfpack_col_to_triplet (n, Ap, Tj) ;

long Syntax:

    #include "umfpack.h"
    long n, *Tj, *Ap, status ;
    status = umfpack_l_col_to_triplet (n, Ap, Tj) ;

Purpose:

    Converts a column-oriented matrix to a triplet form.  Only the column
    pointers, Ap, are required, and only the column indices of the triplet form
    are constructed.   This routine is the opposite of umfpack_triplet_to_col.
    The matrix may be singular.

Returns:

    UMFPACK_OK if successful
    UMFPACK_ERROR_argument_missing if Ap or Tj is missing
    UMFPACK_ERROR_n_nonpositive if n <= 0
    UMFPACK_ERROR_Ap0_nonzero if Ap [0] != 0
    UMFPACK_ERROR_nz_negative if Ap [n] < 0
    UMFPACK_ERROR_col_length_negative if Ap [j] > Ap [j+1] for any j in the
	range 0 to n-1.
    Empty rows, unsorted columns, and duplicate entries do not cause an error
    (these would only be evident by examining Ai).  Empty columns are OK.

Arguments:

    Int n ;		Input argument, not modified.

	A is an n-by-n matrix.  Restriction: n > 0.

    Int Ap [n+1] ;	Input argument, not modified.

	The column pointers of the column-oriented form of the matrix.  See
	umfpack_symbolic for a description.  The number of entries in
	the matrix is nz = Ap [n].  Restrictions on Ap are the same as those
	for umfpack_transpose.  Ap [0] must be zero, nz must be >= 0, and
	Ap [j] <= Ap [j+1] and Ap [j] <= Ap [n] must be true for all j in the
	range 0 to n-1.  Empty columns are OK (that is, Ap [j] may equal
	Ap [j+1] for any j in the range 0 to n-1).

    Int Tj [nz] ;	Output argument.

	Tj is an integer array of size nz on input, where nz = Ap [n].
	Suppose the column-form of the matrix is held in Ap, Ai, and Ax
	(see umfpack_symbolic for a description).  Then on output, the triplet
	form of the same matrix is held in Ai (row indices), Tj (column
	indices), and Ax (numerical values).  Note, however, that this routine
	does not require Ai and Ax in order to do the conversion.

*/
