/* ========================================================================== */
/* === UMF_symbolic_usage =================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/* Returns the final size of the Symbolic object, in Units */

#include "umf_internal.h"

GLOBAL double UMF_symbolic_usage
(
    Int n,
    Int nchains,
    Int nfr
)
{
    double units = DUNITS (SymbolicType, 1)	/* Symbolic structure */
	+ DUNITS (Int, n+1)		/* Cperm_init */
	+ 3*DUNITS (Int, nchains+1)	/* Chain_ */
	+ 2*DUNITS (Int, nfr+1) ;	/* Front_ */

    return (units) ;
}

