//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uIStream.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:51:42 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jul 19 23:01:46 2004
// Update Count     : 44
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_ISTREAM_H__
#define __U_ISTREAM_H__


#include <uFilebuf.h>
#include <uIos.h>

#pragma __U_NOT_USER_CODE__

#include <istream>


class uIStream;						// forward
class uOStream;						// forward

uIStream &ws( uIStream &is );

uIStream &boolalpha( uIStream &os );
uIStream &noboolalpha( uIStream &os );
uIStream &showbase( uIStream &os );
uIStream &noshowbase( uIStream &os );
uIStream &showpoint( uIStream &os );
uIStream &noshowpoint( uIStream &os );
uIStream &showpos( uIStream &os );
uIStream &noshowpos( uIStream &os );
uIStream &skipws( uIStream &os );
uIStream &noskipws( uIStream &os );
uIStream &uppercase( uIStream &os );
uIStream &nouppercase( uIStream &os );
uIStream &unitbuf( uIStream &os );
uIStream &nounitbuf( uIStream &os );

uIStream &internal( uIStream &os );
uIStream &left( uIStream &os );
uIStream &right( uIStream &os );

uIStream &dec( uIStream &is );
uIStream &hex( uIStream &is );
uIStream &oct( uIStream &is );

uIStream &fixed( uIStream &os );
uIStream &scientific( uIStream &os );

uIStream &uAcquire( uIStream &is );
uIStream &uRelease( uIStream &is );

uIStream &operator >> ( uIStream &is, char &c );
uIStream &operator >> ( uIStream &is, signed char &c );
uIStream &operator >> ( uIStream &is, unsigned char &c );
uIStream &operator >> ( uIStream &is, char *s );
uIStream &operator >> ( uIStream &is, signed char *s );
uIStream &operator >> ( uIStream &is, unsigned char *s );


class uIStream : public uIos {
    friend uIStream &ws( uIStream &is );
    friend uIStream &boolalpha( uIStream &os );
    friend uIStream &noboolalpha( uIStream &os );
    friend uIStream &showbase( uIStream &os );
    friend uIStream &noshowbase( uIStream &os );
    friend uIStream &showpoint( uIStream &os );
    friend uIStream &noshowpoint( uIStream &os );
    friend uIStream &showpos( uIStream &os );
    friend uIStream &noshowpos( uIStream &os );
    friend uIStream &skipws( uIStream &os );
    friend uIStream &noskipws( uIStream &os );
    friend uIStream &uppercase( uIStream &os );
    friend uIStream &nouppercase( uIStream &os );
    friend uIStream &unitbuf( uIStream &os );
    friend uIStream &nounitbuf( uIStream &os );
    friend uIStream &internal( uIStream &os );
    friend uIStream &left( uIStream &os );
    friend uIStream &right( uIStream &os );
    friend uIStream &dec( uIStream &is );
    friend uIStream &hex( uIStream &is );
    friend uIStream &oct( uIStream &is );
    friend uIStream &fixed( uIStream &os );
    friend uIStream &scientific( uIStream &os );
    friend uIStream &uAcquire( uIStream &is );
    friend uIStream &uRelease( uIStream &is );

    friend uIStream &operator >> ( uIStream &is, char &c );
    friend uIStream &operator >> ( uIStream &is, signed char &c );
    friend uIStream &operator >> ( uIStream &is, unsigned char &c );
    friend uIStream &operator >> ( uIStream &is, char *s );
    friend uIStream &operator >> ( uIStream &is, signed char *s );
    friend uIStream &operator >> ( uIStream &is, unsigned char *s );

    uIStream( uIStream & );				// no copy
    uIStream &operator=( uIStream & );			// no assignment
  protected:
    // Could not use public inheritance because of mutual exclusion problems
    // and cascading (contra-variance).

    std::istream ifile;

    // The concept of "tied" involves 2 files, which causes mutual exclusion
    // problems if the tied-file is not a uOStream. As a result, all aspects of
    // tied had to performed in the derived class and not the base class to
    // ensure that uOStream's routine are called. If member routine flush was
    // virtual, this would not have been necessary.

    uOStream *tied_to;
  protected:
    int deletebuf;					// should the buffer be deleted on termination ?
  public:
    uIStream( std::streambuf *buf, uOStream *tied = NULL );
    virtual ~uIStream();

    std::streamsize gcount();
    std::streambuf::int_type get();
    uIStream &get( std::streambuf::char_type &c );
    uIStream &get( std::streambuf::char_type *ptr, std::streamsize len, std::streambuf::char_type delim = '\n' );
    uIStream &get( std::streambuf &sb, std::streambuf::char_type delim = '\n' );
    uIStream &getline( std::streambuf::char_type *ptr, std::streamsize len, std::streambuf::char_type delim = '\n' );
    uIStream &ignore( std::streamsize n = 1, std::streambuf::int_type delim = EOF );
    std::streambuf::int_type peek();
    uIStream &read( std::streambuf::char_type *ptr, std::streamsize n );
    std::streamsize readsome( std::streambuf::char_type *ptr, std::streamsize n );
    uIStream &putback( std::streambuf::char_type c );
    uIStream &unget();
    int sync();
    std::streambuf::pos_type tellg();
    uIStream &seekg( std::streambuf::pos_type pos );
    uIStream &seekg( std::streambuf::off_type off, std::ios_base::seekdir dir );

    uIStream &operator >> ( uIStream &( *f )( uIStream & ) );
    uIStream &operator >> ( bool &n );
    uIStream &operator >> ( short &n );
    uIStream &operator >> ( unsigned short &n );
    uIStream &operator >> ( int &n );
    uIStream &operator >> ( unsigned int &n );
    uIStream &operator >> ( long &n );
    uIStream &operator >> ( unsigned long &n );
    uIStream &operator >> ( float &n );
    uIStream &operator >> ( double &n );
    uIStream &operator >> ( long double &n );
    uIStream &operator >> ( void *&p );
    uIStream &operator >> ( long long &n );
    uIStream &operator >> ( unsigned long long &n );

    uOStream *tie();
    uOStream *tie( uOStream *os );

    std::istream &stream();
}; // uIStream


//######################### uIStreamModule #########################


class uIStreamModule {
  public:
    static uFilebuf *uCinFilebuf;
    static uIStream *uCinStream;
}; // uIStreamModule


#define uCin (*uIStreamModule::uCinStream)


//######################### uIStream Boot #########################


class uIStreamBoot {
    static int uCount;

    static void startup();
    static void finishup();
  public:
    uIStreamBoot() {
	uCount += 1;
	if ( uCount == 1 ) {
	    startup();
	} // if
    } // uIStreamBoot::uIStreamBoot

    ~uIStreamBoot() {
	if ( uCount == 1 ) {
	    finishup();
	} // if
	uCount -= 1;
    } // uIStreamBoot::uIStreamBoot
}; // uIStreamBoot


// Create an instance in each translation unit, but only the first instance to
// execute performs the system bootstrap. Do not include instances in the
// kernel modules.

#ifndef __U_KERNEL__
static uIStreamBoot uBootuIStream;
#endif // __U_KERNEL__


#pragma __U_USER_CODE__

#endif // __U_ISTREAM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
