//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uBootTask.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Thu Apr 28 13:31:12 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jun 26 18:48:18 2004
// Update Count     : 128
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uBootTask.h>


void uBootTask::main() {
    // NEVER INVOKED BECAUSE BOOT TASK IS ALREADY RUNNING USING THE UNIX THREAD.
} // uBootTask::main


void *uBootTask::operator new( size_t, void *storage ) {
    return storage;
} // uBootTask::operator new


void *uBootTask::operator new( size_t size ) {
    return ::operator new( size );
} // uBootTask::operator new


uBootTask::uBootTask() : uBaseTask( *uKernelModule::uSystemCluster ) {
    // SKULLDUGGERY: Explicitly make this task look like the currently
    // executing task.

    THREAD_GETMEM( uActiveProcessor )->uCurrTask = this;
    THREAD_SETMEM( uActiveTask, this );

    // SKULLDUGGERY: uC++ stack is only used by profiler. This getcontext
    // overwrites the area initialized by uMachContext (makecontext) with the
    // current UNIX stack so the UNIX stack is used instead of the uC++ one.

    if ( ::getcontext( (ucontext *)uStorage ) == -1 ) {
	uAbort( "internal error, getcontext failed" );
    } // if

    // SKULLDUGGERY: Remove "main" from the suspend stack so it is never
    // executed. This trick makes this task into a pseudo-task to execute the
    // global constructor and destructor lists.

    uSerialInstance.uAcceptSignalled.uDrop();

    // SKULLDUGGERY: Because this task has been removed from the suspend stack,
    // it is not woken by uSerialConstructor so do this manually by putting the
    // task on the ready queue.

    uWake();
} // uBootTask::uBootTask


uBootTask::~uBootTask() {
    // SKULLDUGGERY: Since this task does not have a "main" routine, some of
    // its termination code must be performed manually.

    uNotHalted = false;
} // uBootTask::~uBootTask


// Local Variables: //
// compile-command: "gmake install" //
// End: //
