//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uAlign.h -- 
// 
// Author           : Peter Buhr
// Created On       : Sat Dec 18 22:08:40 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Oct 22 15:15:02 2003
// Update Count     : 29
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_ALIGN_H__
#define __U_ALIGN_H__


// Minimum size used to align memory boundaries for memory allocations. Minimum
// size must be >= sizeof(uHeapManager::uStorage::uHeader).

#define uAlign() (2 * sizeof(void *))


// Returns value aligned at the floor of align.

static inline unsigned long int uFloor( unsigned long int value, unsigned long int align ) {
    return value - ( value % align );
} // uFloor


// Returns value aligned at the ceiling of align.

static inline unsigned long int uCeiling( unsigned long int value, unsigned long int align ) {
    value += align - 1;
    return uFloor( value, align );
} // uCeiling


#endif // __U_ALIGN_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
