//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// Migrate.cc -- Test migrating of tasks among clusters.
// 
// Author           : Peter Buhr
// Created On       : Tue Jun 28 10:23:11 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Aug  8 08:53:42 2004
// Update Count     : 83
// 

#include <uC++.h>
#include <uIOStream.h>


#define NoOfClusters 2

unsigned int uDefaultPreemption() {
    return 1;
} // uDefaultPreemption

unsigned int uDefaultSpin() {
    return 1000;
} // uDefaultSpin

uTask dummy {
    int id;
    uCluster **c;

    void main() {
	const int NoOfTimes = 20;
	char name[20];
	sprintf( name, "dummy%d", id );
	uSetName( name );

        for ( int i = 0; i < NoOfTimes; i += 1 ) {
	    for ( int j = 0; j < NoOfClusters; j += 1, id = (id + 1) % NoOfClusters ) {
		uMigrate( *(c[id]) );
	    } // for
        } // for
    } // dummy::main
  public:
    dummy( int id, uCluster &create, uCluster *c[] ) : id( id ), uBaseTask( create ), c( c ) {
    } // dummy::dummy
}; // dummy


void uMain::main() {
    const int NoOfTasks = 3;

    uCluster *c[NoOfClusters];
    uProcessor *p[NoOfClusters];
    dummy *t[NoOfTasks];
    int i, j;

    c[0] = &uThisCluster();				// default cluster and processor
    p[0] = &uThisProcessor();

    for ( i = 1; i < NoOfClusters; i += 1 ) {		// create N-1 clusters and processors
	c[i] = new uCluster();
	p[i] = new uProcessor( *(c[i]) );
    } // for

    for ( i = 0, j = 0; i < NoOfTasks; i += 1, j = (j + 1) % NoOfClusters ) { // create tasks
	t[i] = new dummy( j, *(c[j]), c );
    } // for
    for ( i = 0; i < NoOfTasks; i += 1 ) {		// delete tasks
	delete t[i];
    } // for

    for ( i = 1; i < NoOfClusters; i += 1 ) {		// delete N-1 clusters and processors
	delete p[i];
	delete c[i];
    } // for

    uCout << "successful completion" << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ Migrate.cc" //
// End: //
