//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1999
// 
// ClientUNIX2.cc -- Client for UNIX/datagram socket test. Client reads from
// standard input, writes the data to the server, reads the data from the
// server, and writes that data to standard output.
// 
// Author           : Peter A. Buhr
// Created On       : Thu Apr 29 16:05:12 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Nov 21 08:52:14 2003
// Update Count     : 22
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uSocket.h>
#include <uSemaphore.h>

#define EOD '\377'
// minimum buffer size is 2, 1 character and string terminator, '\0'
#define BufferSize (65)

int rcnt = 0, wcnt = 0;

// Datagram sockets are lossy (i.e., drop packets). To prevent clients from
// flooding the server with packets, resulting in dropped packets, a semaphore
// is used to synchronize the reader and writer tasks so at most N writes occur
// before a read. As well, if the buffer size is increase substantially, it may
// be necessary to decrease N to ensure the server buffer does not fill.

const int MaxWriteBeforeRead = 5;
uSemaphore readSync(MaxWriteBeforeRead);

uTask reader {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];
		int len;

		for ( ;; ) {
			len = client.recvfrom( buf, sizeof(buf) );
			readSync.V();
			// uCerr << uAcquire << "Client::reader read len:" << len << endl << uRelease;
		  if ( buf[0] == EOD ) break;
			// The EOD character can be piggy-backed onto the end of the message.
		  if ( buf[len - 1] == EOD ) { rcnt += len - 1; uCout.write( buf, len - 1 ); break; }
			rcnt += len;
			uCout.write( buf, len );
		} // for
	} // reader::main
  public:
	reader( uSocketClient &client ) : client ( client ) {
	} // reader::reader
}; // reader

uTask writer {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];

		for ( ;; ) {
			uCin.get( buf, sizeof(buf), '\0' );	// leave room for string terminator
			int len = strlen( buf );
			// uCerr << uAcquire << "Client::writer read len:" << len << endl << uRelease;
		  if ( buf[0] == '\0' ) break;
			wcnt += len;
			readSync.P();
			client.sendto( buf, len );
		} // for
		buf[0] = EOD;
		readSync.P();
		client.sendto( buf, sizeof(char) );
	} // writer::main
  public:
	writer( uSocketClient &client ) : client( client ) {
	} // writer::writer
}; // writer

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << " socket-name" << endl;
		uExit( -1 );
	} // switch

	uSocketClient client( argv[1], SOCK_DGRAM );		// connection to server
	{
		reader rd( client );							// emit worker to read from server and write to output
		writer wr( client );							// emit worker to read from input and write to server
	}
	if ( wcnt != rcnt ) {
		uAbort( "not all data transfered\n" );
	} // if
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Client ClientUNIX2.cc" //
// End: //
