//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// FibPar.cc -- Produce the fibonacci numbers in sequence on each call.
//
//  No explicit states, communication with argument-parameter
//  mechanism between suspend and resume
//
//  Demonstrate multiple instances of the same coroutine.
//
//  Accessiable by multiple threads
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:55:37 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Aug  8 08:51:47 2004
// Update Count     : 84
// 

#include <uC++.h>
#include <uIOStream.h>


uMutex uCoroutine fibonacci {
    int fn, fn1, fn2;

    void main() {
	fn = 1;						// 1st case
	fn1 = fn;
	uSuspend;
	fn = 1;						// 2nd case
	fn2 = fn1;
	fn1 = fn;
	uSuspend;
	for ( ;; ) {					// general case
	    fn = fn1 + fn2;
	    fn2 = fn1;
	    fn1 = fn;
	    uSuspend;
	} // for
    } // fibonacci::main
  public:
    int next() {
	uResume;
	return fn;
    } // fibonacci::next
}; // fibonacci

uTask Worker {
    fibonacci &f1, &f2;
    int n1, n2;
    
    void main() {
	uYield( rand() % 10 );
	n1 = f1.next();
	uYield( rand() % 10 );
	n2 = f2.next();
	uCout << uAcquire << "task " << &uThisTask() << " " << n1 << " " << n2 << endl << uRelease;
    } // Worker::main
  public:
    Worker( fibonacci &f1, fibonacci &f2 ) : f1( f1 ), f2( f2 ) {
    } // Worker::Worker
}; // Worker

void uMain::main() {
    const int NoOfWorkers = 10;
    fibonacci f1, f2;					// create fibonacci generator

    srand( getpid() );
    uCout << "Fibonacci Numbers" << endl;

    Worker *workers = new Worker[NoOfWorkers]( f1, f2 );
    delete [] workers;

    uCout << uAcquire << "successful completion" << endl << uRelease;
} // uMain::main

// Local Variables: //
// compile-command: "u++ FibPar.cc" //
// End: //
