//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1998
// 
// EHM3.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Oct 27 21:24:48 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jan 28 23:22:58 2004
// Update Count     : 8
// 

#include <uC++.h>
#include <uOStream.h>

uRaiseEvent R1 {
  public:
	int &i; char &c;
	R1( int &i, char &c ) : i( i ), c( c ) {}
};
uInitEvent(R1);

uRaiseEvent R2 {};
uInitEvent(R2);


void f( int x, char y ) {
	uCout << uAcquire << "enter f, x:" << x << " y:" << y << uRelease << endl;
	uRaise R2();
	uCout << uAcquire << "exit f, x:" << x << " y:" << y << uRelease << endl;
}
void g( int &x, char &y ) {
	uCout << uAcquire << "enter g, x:" << x << " y:" << y << uRelease << endl;
	uRaise R1( x, y );
	uCout << uAcquire << "exit g, x:" << x << " y:" << y << uRelease << endl;
}

void rtn1( R1 &r ) {
	uCout << uAcquire << "rtn1" << uRelease << endl;
	r.i = 1; r.c = 'b';
}

struct Rtn2 {
	int &i; char &c;
	Rtn2( int &i, char &c ) : i( i ), c( c ) {}
	void operator()( R2 &r ) {
		uCout << uAcquire << "rtn2, i:" << i << " c:" << c << uRelease << endl;
		i = 2; c = 'c';									// change x, y
	}
};


void uMain::main() {
	try <R1,rtn1> {
		int x = 0;
		char y = 'a';
		Rtn2 rtn2( x, y );								// closure for locals

		g( x, y );
		uCout << uAcquire << "try<R1,rtn1> x:" << x << " y:" << y << uRelease << endl;

		// Check multiple handlers, only one is used.
		try <R1><R2,rtn2> {
			f( x, y );
			uCout << uAcquire << "try<R2,rtn2>, x:" << x << " y:" << y << uRelease << endl;
		} // try
		try <R1><R2,rtn2> {								// R1 empty handler
			g( x, y );
			uCout << uAcquire << "try<R1>, x:" << x << " y:" << y << uRelease << endl;
		} // try
	} // try
}

// Local Variables: //
// tab-width: 4 //
// End: //
