#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
import tryton.rpc as rpc
from preference import *


class Window(object):

    hide_current = False
    allow_similar = False

    def __init__(self, hide_current=False, allow_similar=True):
        Window.hide_current = hide_current
        Window.allow_similar = allow_similar

    def __enter__(self):
        return self

    def __exit__(self, type, value, traceback):
        Window.hide_current = False
        Window.allow_similar = False

    @staticmethod
    def create(view_ids, model, res_id=False, domain=None,
            context=None, mode=None, name=False, limit=None,
            auto_refresh=False, search_value=None, icon=None):
        from tryton.gui import Main
        if context is None:
            context = {}

        if model:
            from form import Form
            win = Form(model, res_id, domain, mode=mode,
                view_ids=(view_ids or []), context=context, name=name,
                limit=limit, auto_refresh=auto_refresh,
                search_value=search_value)
        else:
            from board import Board
            win = Board(model, view_ids and view_ids[0] or None,
                context=context, name=name, auto_refresh=auto_refresh)
        win.icon = icon
        Main.get_main().win_add(win, hide_current=Window.hide_current,
            allow_similar=Window.allow_similar)

    @staticmethod
    def create_wizard(action, data, state='init', direct_print=False,
            email_print=False, email=None, name=False, context=None, icon=None,
            window=False):
        from tryton.gui import Main
        from wizard import WizardForm, WizardDialog
        if window:
            win = WizardForm(name=name)
            win.icon = icon
            Main.get_main().win_add(win, Window.hide_current)
        else:
            win = WizardDialog(name=name)
        win.run(action, data, state=state, direct_print=direct_print,
                email_print=email_print, email=email, context=context)
