/* CtrafStatsEntry.C: function definitions for the stats themselves
   * Source/port, destination/port, amount. (timestamp gets added 
   * runtime during insertion in the database)
   
   Functions: 
   	* Constructor
	* copy constructor (need it for the list)
	* Destructor
	* < operator - checks source then sport then destination then dport
	* += operator - adds two entries -- IF THEY MATCH.
	* + operator (see above)
	* matches - returns true if all but amount the comparant
	* asString - returns printable version of contents, for logging 
	  purposes
	* print - prints it out
	* asQuery - Takes a timestamp and returns an SQL INSERT query

	
*/

#include "trafstats.h"
#include <stdio.h>
#include <assert.h>
#include <arpa/inet.h>
#include <strstream.h>

using namespace std;
CTrafStatsEntry::CTrafStatsEntry(struct in_addr source,
		int sport,
		struct in_addr destination,
		int dport,
		char* timestamp,
		unsigned long amount) 
{
	iSource=source;
	iSport=sport;
	iDestination=destination;
	iDport=dport;
	iTimestamp=timestamp;
	iAmount=amount;
}


bool CTrafStatsEntry::operator<(const CTrafStatsEntry& match) {
#ifdef _DEBUG_
#define SDLOG(x) if (verbosity >= LOG_DEBUG + 6) { syslog(LOG_DEBUG,x); }
#else
#define SDLOG(x)
#endif
	SDLOG("Starting comparison.");
	
	if (!(iSource.s_addr >= match.source().s_addr)) {
		SDLOG("Source_addr decides: TRUE");
		return true;
	} else if (iSource.s_addr > match.source().s_addr) {
		SDLOG("Source_addr decides: FALSE");
		return false;
	}
	// else iSource.s_addr == match.source().s_addr
	
	if (!(iSport>=match.sport())) {
		SDLOG("Sport decides: TRUE");
		return true;
	} else if (iSport > match.sport()) {
		SDLOG("Sport decides: FALSE");
		return false;
	}
	// else iSport == match.sport()
	
	if (!(iDestination.s_addr>=match.destination().s_addr)) {
		SDLOG("Destination decides: TRUE");
		return true;
	} else if (iDestination.s_addr>match.destination().s_addr) {
		SDLOG("Destination decides: FALSE");
		return false;
	}
	// else iDestination.s_addr == match.destination().s_addr
	if (!(iTimestamp>=match.timestamp())) {
		SDLOG("Timestamp decides: TRUE");
		return true;
	} else if (iTimestamp > match.timestamp()) {
		SDLOG("Timestamp decides: FALSE");
		return false;
	}
	SDLOG("Timestamps match.");
	// else iTimestamp == match.timestamp
	SDLOG("Dport decides.");	
	return iDport < match.dport();
#undef SDLOG
}

bool CTrafStatsEntry::matches(const CTrafStatsEntry& match) {
	if(iSource.s_addr!=match.source().s_addr) {
		return false;
	}
	// else
	if (iSport != match.sport()) {
		return false;
	}
	// else
	if(iDestination.s_addr!=match.destination().s_addr) {
		return false;
	}
	// else
	if(iDport !=match.dport()) {
		return false;
	}
	// else
	if(iTimestamp != match.timestamp()) {
		return false;
	}
	// else
	return true;
}
CTrafStatsEntry::~CTrafStatsEntry()
{}

CTrafStatsEntry::CTrafStatsEntry(const CTrafStatsEntry& copy) {
	iSource=copy.source();
	iDestination=copy.destination();
	iSport=copy.sport();
	iDport=copy.dport();
	iTimestamp=copy.timestamp();
	iAmount=copy.amount();
}

CTrafStatsEntry& CTrafStatsEntry::operator+=(const CTrafStatsEntry& addee) {
	assert(iSource.s_addr==addee.iSource.s_addr);
	assert(iDestination.s_addr==addee.destination().s_addr);
	assert(iSport==addee.sport());
	assert(iDport==addee.dport());
	assert(iTimestamp==addee.timestamp());
	// Well, if we're here, they're all the same. 
	// So, without any further ado...
	iAmount += addee.amount(); 
	return *this;
}

void CTrafStatsEntry::print() {
	cout << asString() << endl;
}

string CTrafStatsEntry::asString() const {
	
	ostrstream temp;
	temp << "<<" << inet_ntoa(iSource);
	temp << ":" << iSport << ">";
	
	temp << " --> <";
	temp << inet_ntoa(iDestination) ;
	temp << ":" << iDport << "> ";
	temp << "on " << iTimestamp << ": ";
	temp << iAmount << " bytes.";
	return temp.str();
}

string CTrafStatsEntry::asQuery() const {
	char* ttemp=(char*)malloc(TS_QUERY_SIZE_MAX);
	snprintf(ttemp,
			TS_QUERY_SIZE_MAX,
			"INSERT INTO rawtraffic VALUES('%s',%d, ",
			inet_ntoa(iSource),
			iSport);
	string stemp(ttemp);
	snprintf(ttemp,
			TS_QUERY_SIZE_MAX,
			"'%s', %d, ",
			inet_ntoa(iDestination),
			iDport);
	stemp += ttemp;
	stemp += "TIMESTAMP '";
	stemp += iTimestamp;
	snprintf(ttemp,TS_QUERY_SIZE_MAX,"', %ld);",iAmount);
	stemp += ttemp;
	free(ttemp);
	return stemp;
}
