// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_LU_FACTOR_INC
#define MX_LU_FACTOR_INC

#include "Mat.h"
#include "Vec.h"
#include "Perm.h"

namespace Torch {

/** Collection of matrix factorisation operation functions.
    Based on the "Meschach Library", available at the
    anonymous ftp site thrain.anu.edu.au in the directory
    pub/meschach.

    Most matrix factorisation routines are in-situ
    unless otherwise specified.

    @author David E. Stewart (david.stewart@anu.edu.au)
    @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{

/** Gaussian elimination with scaled partial pivoting.
    -- Note: returns LU matrix which is #A#. */
void mxLUFactor(Mat * mat, Perm * pivot);

/**
   Given an LU factorisation in #A#, solve #Ax=b# */
void mxLUSolve(Mat * mat, Perm * pivot, Vec * b, Vec * x);

/**
   Given an LU factorisation in #A#, solve #A^T.x=b# */
void mxLUTSolve(Mat * mat, Perm * pivot, Vec * b, Vec * x);

/**
   Returns inverse of #A#, provided #A# is not too rank deficient.
   Uses LU factorisation. */
void mxInverse(Mat * mat, Mat * out);

//@}


}

#endif
