// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef PERM_OPERATIONS_INC
#define PERM_OPERATIONS_INC

#include "Perm.h"
#include "Mat.h"
#include "Vec.h"

namespace Torch {

/** Collection of permutations operation functions.
    Based on the "Meschach Library", available at the
    anonymous ftp site thrain.anu.edu.au in the directory
    pub/meschach.

    @author David E. Stewart (david.stewart@anu.edu.au)
    @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{
/** Invert permutation -- in situ.
    Taken from ACM Collected Algorithms 250. */
void mxPermInv(Perm * px, Perm * out);

/** Permutation multiplication (composition) -- not in-situ */
void mxPermMulPerm(Perm * px1, Perm * px2, Perm * out);

/** Permute vector -- can be in-situ */
void mxPermVec(Perm * px, Vec * vec, Vec * out);

/** Apply the inverse of px to x, returning the result in out.
    Can be in-situ, but "oh booooy!"... */
void mxPermInvVec(Perm * px, Vec * x, Vec * out);

/** Transpose elements of permutation.
    Really multiplying a permutation by a transposition.
    i1 and i2 are the elements to transpose. */
void mxTrPerm(Perm * px, int i1, int i2);

/** Permute columns of matrix A; out = A.px'. -- May NOT be in situ */
void mxPermColsMat(Perm * px, Mat * mat, Mat * out);

/** Permute rows of matrix A; out = px.A. -- May NOT be in situ */
void mxPermRowsMat(Perm * px, Mat * mat, Mat * out);

//@}


}

#endif
