// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MULTI_CRITERION_INC
#define MULTI_CRITERION_INC

#include "Criterion.h"

namespace Torch {

/** MultiCriterion can be used to handle multiple criterions.

    The #MultiCriterion# is a #Criterion# which is the weighted
    sum of given criterions. (By default, the weights are equal to #1#).

    @author Samy Bengio (bengio@idiap.ch)
*/
class MultiCriterion : public Criterion
{
  public:

    /// the number of criterions
    int n_criterions;

    /// the criterions
    Criterion** criterions;

    /// the relative weight of each criterion
    real* weights;

    /// do we need to allocate the weights
    bool allocate_weights;

    //-----

    ///
    MultiCriterion(int n_criterions_,Criterion** criterions_,real* weights_ = NULL);

    //-----

    virtual void setDataSet(DataSet *data_);
    virtual void iterInitialize();
    virtual void reset();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);
    virtual ~MultiCriterion();
};


}

#endif
