// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MIXER_INC
#define MIXER_INC

#include "GradientMachine.h"

namespace Torch {

/** Mixer useful for experts mixtures.
    Formally speaking, it computes:
    $outputs[i] = \sum_j a_j * inputs_j[i]$

    where
    \begin{itemize}
      \item ${a_1,...,a_n}$ are in the table
      of the first node of the #inputs# list,
      when you call #forward()#.
      
      \item $inputs_j$ are the inputs of the j-th expert.
      Therefore, the #inputs# list has the structure
      ${a, inputs_1, inputs_2, ...}$.
      Only $a$ must be alone in one node.
    \end{itemize}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class Mixer : public GradientMachine
{
  public:
    int n_experts;

    //-----

    ///
    Mixer(int n_inputs_, int n_outputs_per_expert);

    //-----

    virtual int numberOfParams();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);

    virtual ~Mixer();
};


}

#endif
