// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "FileDataSet.h"

namespace Torch {

FileDataSet::FileDataSet(const char *file, int n_inputs_, int n_targets_, bool bin, int max_load)
{
  melanie.loadData(file, &all_inputs, &all_targets, n_inputs_, n_targets_, &n_real_examples, bin, max_load);
  message("FileDataSet: %d examples loaded", n_real_examples);
  n_targets = n_targets_;
  n_inputs = n_inputs_;
}

FileDataSet::~FileDataSet()
{
  // Auto free for data with IOTorch (TM)
}

}

