// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef BOOSTING_MEASURER_INC
#define BOOSTING_MEASURER_INC

#include "Measurer.h"
#include "List.h"
#include "DataSet.h"
#include "ClassFormat.h"

namespace Torch {

/** Compute the classification error (in %) for #BoostingMachine#
    of the #inputs# with respect to the #targets# of #data#.

    Needed by #Boosting#. (Designed just for it).

    The format of the class is given with a #ClassFormat#.

    #measure# = {<[real] error proportion>, <[real] current number of errors>}

    @author Ronan Collobert (collober@iro.umontreal.ca)
    @author Samy Bengio (bengio@idiap.ch)
    @see Boosting
*/
class BoostingMeasurer : public Measurer
{
  public:
    // General
    List *inputs;
    real *weights;
    real beta;
    int *status;

    // Private (old ClassBoostingMeasurer)
    real *erreur;
    real *erreur_c;
    int current_example;
    ClassFormat *class_format;

    BoostingMeasurer(ClassFormat *class_format_, FILE *file_);
    BoostingMeasurer(ClassFormat *class_format_, const char *filename);

    virtual void setData(DataSet *data_);
    virtual void setWeights(real *weights_);
    virtual void setInputs(List *inputs_);

    //-----

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~BoostingMeasurer();
};


}

#endif
