// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "NllCriterion.h"
#include "log_add.h"

namespace Torch {

NllCriterion::NllCriterion()
{
  n_inputs = 1;
}

void NllCriterion::reset()
{
}

void NllCriterion::forward(List *inputs)
{
  *(real*)outputs->ptr = *(real*)inputs->ptr;
}

void NllCriterion::backward(List *inputs, real *alpha)
{
  *beta = 1;
}

NllCriterion::~NllCriterion()
{
}

}

