// Copyright (C) 2002 Samy Bengio (samy.bengio@idiap.ch)
//                and Bison Ravi (francois.belisle@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MAT_SEQ_DATASET_INC
#define MAT_SEQ_DATASET_INC

#include "SeqDataSet.h"
#include "StdDataSet.h"

namespace Torch {


/** This class enable to read sequences (hence inherits from #SeqDataSet#)
    from the classical Torch data format. Depending on the options, it
    can read one sequence per line (thus having sequences of size 1)
    or one sequence per file (then having sequences of size the size of
    the files). One can specify the number of inputs, observations and
    targets in the given file.
   
   @author Bison Ravi (francois.belisle@idiap.ch)
   @author Samy Bengio (samy.bengio@idiap.ch)
 */
class MatSeqDataSet : public SeqDataSet
{
  public :

    /** this boolean is used to know if the data has already been read
        by a #StdDataSet# and hence do not need to be freed at the end.
    */
    bool examples_from_stddataset;
    
    MatSeqDataSet();

    MatSeqDataSet( char* file, int n_inputs_, int n_observations_, int n_targets_,  
                   bool bin=false,  int max_load=-1 );
    MatSeqDataSet( char** files, int n_files, int n_inputs_, int n_observations_, int n_targets_,
                   bool bin=false,  int max_load=-1 );
    
    ///puts a data set in the Sequence framework
    MatSeqDataSet( StdDataSet* data,int n_inputs_,int n_observations_);

    virtual ~MatSeqDataSet();


    /** the following method is inherited from #SeqDataSet# */
    
    /** destroys data allocated by #createData# and the constructor 
     */
    virtual void freeMemory();

    /** reads the data into the #all_inputs# structure which
     * will be transfered in the #examples# structure in 
     * #createData#
     */
    void readMat( char* file, bool bin=false, int max_load=-1 );
    
    /** finds the number of lines in all of the given files */
    int lines( char* , bool bin );
    int lines( char**, int n_files, bool bin);
    
    /** finds the number of columns in a file */
    int columns( char* , bool bin );
};


}

#endif     
