# $Id: wmdock.tcl,v 1.5 2004/01/04 17:49:25 aleksey Exp $

if {![cequal $::interface tk]} return

if {![info exists ::wmaker_dock] || !$::wmaker_dock} {
    return
}

namespace eval ::wmdock {
    set save_status ""
    set balloon_msg ""
    set msgs 0
    array set msgsc {}
    set msg_afterid ""
    set icon(user)    [Bitmap::get [pixmap browser user.gif]]
    set icon(message) [Bitmap::get [pixmap tkabber new-msg.gif]]
}

proc ::wmdock::change_status {status} {
    variable save_status
    variable msgs
    variable balloon_msg

    set save_status $status
    set balloon_msg $status
    .icon.c itemconfigure text -text [concat $msgs "msgs"]
    .icon.c itemconfigure icon -image $::ifacetk::roster::rostericon(user,$status)
}


proc ::wmdock::msg_recv {chatid from type body x} {
    variable msg_afterid 
    variable balloon_msg 
    variable msgs 
    variable msgsc
    variable icon
    
    if {[chat::is_our_jid $chatid $from] || ![cequal $type chat]} {
	return
    }
    
    set cw [chat::winid $chatid]
    set page [crange [win_id tab $cw] 1 end]
    if {$::usetabbar && $page != [.nb raise]} {
	if {![info exists msgsc($chatid)]} {
	    set msgsc($chatid) 0
	}
	incr msgsc($chatid) 1
	incr msgs 1
    }
    
    #	set balloon_msg [concat "Message from" [roster::get_label $from] ]
    set balloon_msg [format [::msgcat::mc "Message from %s"] $from]
    
    after cancel $msg_afterid
    .icon.c itemconfigure icon -image $icon(message)
    .icon.c itemconfigure text -text [format [::msgcat::mc "%s msgs"] $msgs]
    
    set msg_afterid [after 5000 ::wmdock::clear_msg_status]
}

proc ::wmdock::msg_read {path chatid} {
    variable msgs
    variable msgsc
    
    if {[info exists msgsc($chatid)]} {
	set msgs [expr $msgs - $msgsc($chatid)]
	unset msgsc($chatid)
    }
    .icon.c itemconfigure text -text [format [::msgcat::mc "%s msgs"] $msgs]
}

proc ::wmdock::presence_recv {who status} {
    variable msg_afterid
    variable balloon_msg
    variable icon
    
    set balloon_msg [format [::msgcat::mc "%s is %s"] $who $status]
    
    after cancel $msg_afterid
    .icon.c itemconfigure icon -image $icon(user)
    
    set msg_afterid [after 10000 ::wmdock::clear_msg_status]
}

proc ::wmdock::clear_msg_status {} {
    variable save_status
    variable balloon_msg
    
    set balloon_msg $save_status
    .icon.c itemconfigure icon -image $::ifacetk::roster::rostericon(user,$save_status)
}


proc ::wmdock::showhide {} {
    if {[wm state .] == "withdrawn"} {
	wm deiconify .
	wm state . normal
    } else {
	wm withdraw .
    }
}

proc ::wmdock::dock_balloon {ev x y} {
    variable balloon_msg
    
    balloon::default_balloon .icon $ev $x $y $balloon_msg
}

proc ::wmdock::create_dock {} {
    variable balloon_msg
    
    if {[cequal [wm iconwindow .] ""]} {
	toplevel .icon
	wm iconwindow . .icon
    }
    
    wm command . [file join [pwd] $::argv0]
    
    canvas .icon.c -background black -width 52 -height 52 -relief sunken
    .icon.c create image 26 26 -anchor s \
	-image $::ifacetk::roster::rostericon(user,unavailable) -tag icon
    .icon.c create text 26 52 -anchor s -text "no" -fill white -tag text
    pack .icon.c
    
    bind .icon <3> ::wmdock::showhide
    
    bind .icon <Any-Enter>  [list ::wmdock::dock_balloon enter %X %Y]
    bind .icon <Any-Motion> [list ::wmdock::dock_balloon motion %X %Y]
    bind .icon <Any-Leave>  [list balloon::default_balloon .icon leave  %X %Y]
}

::wmdock::create_dock
hook::add change_our_presence_post_hook ::wmdock::change_status 15
hook::add draw_message_hook ::wmdock::msg_recv 70
hook::add on_change_user_presence_hook ::wmdock::presence_recv 15
hook::add raise_chat_tab_hook ::wmdock::msg_read 15
