/* -*- mode: c; c-file-style: "gnu" -*-
 * primes.h -- initial DH primes for Thy
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file primes.h
 * Initial DH primes for Thy.
 *
 * In order to speed up the startup time, Thy does not generate a
 * new DH prime upon every startup, but only when it receives a
 * SIGHUP.
 */

#ifndef _THY_PRIMES_H
#define _THY_PRIMES_H /**< primes.h multi-include guard */

/** Initial DH primes, 1024 bits.
 */
static unsigned char thy_prime_dh_1024[] = {
  0xB4,0x50,0x7E,0x49,0xCB,0x39,0x5D,0x59,0xA9,0xE1,0xF6,0xD3,
  0x99,0x9C,0x3A,0xA4,0xF9,0x9F,0x89,0x27,0x8C,0x6C,0xCD,0xFE,
  0xA0,0x8A,0xA9,0x63,0x9D,0x05,0x28,0x59,0xFB,0xC2,0x09,0x50,
  0xC5,0x83,0xF0,0x70,0x08,0x91,0x81,0xFC,0x96,0x97,0x0F,0x22,
  0x0B,0x93,0x80,0x3F,0x6C,0xBA,0x3F,0x8C,0x74,0x13,0x44,0xAC,
  0x0E,0x2D,0x0C,0xA6,0xEC,0xAF,0x4C,0x04,0xCB,0x92,0x9C,0xAF,
  0x5D,0xD3,0xBB,0xC7,0xD3,0xB1,0x6F,0x14,0x77,0x61,0xA6,0x1E,
  0x86,0x84,0x51,0x03,0xC3,0x58,0x31,0xD6,0xE9,0xBF,0x1D,0x10,
  0x5F,0xA9,0x1A,0xFE,0x2E,0x4F,0xD8,0x7D,0x84,0x28,0xEA,0xCC,
  0x63,0xB8,0xCA,0x2B,0x67,0x3C,0x93,0xC4,0x0F,0xD1,0xB5,0xAF,
  0x5C,0xBB,0xBE,0xC1,0x31,0xB0,0xB7,0x4B
};
/** DH generator.
 */
static unsigned char thy_generator_dh[]={ 0x02 };

#endif
