/** @file misc.h
 * Miscellaneous routine prototypes *//* -*- mode: c; c-file-style: "gnu" -*-
 * misc.h -- Miscellaneous routine prototypes
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy-Auth.
 *
 * Thy-Auth is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Thy-Auth is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef _THY_AUTH_MISC_H
#define _THY_AUTH_MISC_H 1 /**< misc.h multi-inclusion guard. */

#include "compat/compat.h"

/** The protocol level Thy-Auth supports.
 */
#define _THY_AUTH_PROTOCOL_VERSION 2

char **thy_auth_args_read (int argc);
void thy_auth_do_one (void);
void thy_auth_respond (const char *msg, size_t length);

/** Authenticate a user.
 * This function takes at most four arguments in argv: USER, PASSWORD,
 * REALM and FILE. Based on these, it must perform the authentication,
 * and return 1 if the user should be let in, 0 otherwise.
 *
 * This is implemented by all Authorisers.
 */
extern void _thy_auth_do_one_auth (int argc, char **argv);
/** Check if authentication is needed.
 * Takes one argument in argv: PATH. Then checks if Authorisation is
 * needed at all. If no, returns zero. If yes, returns one, then the
 * length of the realm, then the realm itself.
 *
 * This is implemented by all Authorisers.
 */
extern void _thy_auth_do_one_check (int argc, char **argv);

#endif /* !_THY_AUTH_MISC_H */
