/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef FILEDLG_H_INCLUDED
#define FILEDLG_H_INCLUDED

#include <string>

#include <gtk--/fileselection.h>

#include "thoughttracker.h"

class TTFileDialog : public Gtk::FileSelection {
  public:
    TTFileDialog(Gtk::Window *transient, const string &title = 0);
    virtual ~TTFileDialog() {};

    /* runs the dialog modally and returns the chosen file name or a zero-
       length string */
    virtual string run();

  private:
    int done;  // 0 = no, 1 = OK, 2 = Cancel

    /* handles buttons */
    virtual void btn_ok() { done = 1; };
    virtual void btn_cancel() { done = 2; };

    /* handles "delete" events */
    virtual int delete_event_impl(GdkEventAny *event) {
      done = 2;
      return 0;
    }
};

#endif  /* FILEDLG_H_INCLUDED */

