/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <dvi-2_6.h>
#include <gtk/gtk.h>

#include "defs.h"
#include "xgdvi.h"
#include "gui.h"
#include "buff.h"


static void
on_destry                              (GtkObject      *obj,
                                        gpointer        user_data);

void
on_psButtonOK_clicked                  (GtkButton       *button,
                                        gpointer         user_data);
void
on_psButtonCancel_clicked              (GtkButton       *button,
                                        gpointer         user_data);



static int        PaperSelectionShown  = 0;
static GtkWidget *PaperSelection       = NULL;

static GtkWidget *PaperSelectionMenu   = NULL;
static GtkWidget *OrientSelectionMenu  = NULL;

static GtkWidget *paper_optmenu_paper  = NULL;
static GtkWidget *paper_optmenu_orient = NULL;


struct s_menu_items {
  GtkWidget  *item;
  gchar      *label;
  int         data;
};

static struct s_menu_items  MenuItemsPaper[64];
static struct s_menu_items  MenuItemsOrient[5];


GtkWidget*
create_PaperSelection ()
{
  GtkWidget *dialog_vbox;
  GtkWidget *separator;
  GtkWidget *frame1;
  GtkWidget *frame2;
  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *achbox;
  GtkWidget *psButtonOK;
  GtkWidget *psButtonCancel;
  int  i;

  for (i = 0; ; i++){
    MenuItemsPaper[i].label = paper_list[i];
    MenuItemsPaper[i].item = NULL;
    MenuItemsPaper[i].data = 0;
    if (paper_list[i] == NULL) 
      break;
  }

  MenuItemsOrient[0].label = _("Portrait");
  MenuItemsOrient[0].data  = ORI_PORT;
  MenuItemsOrient[1].label = _("Landscape");
  MenuItemsOrient[1].data  = ORI_LAND;
  MenuItemsOrient[2].label = NULL;
  MenuItemsOrient[2].data  = 0;


  PaperSelection = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  PaperSelectionShown = 0;

#if 0
  gtk_widget_set_events(PaperSelection, GDK_KEY_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(PaperSelection), "key_press_event", 
		     GTK_SIGNAL_FUNC(event_key_press), NULL);
#endif
  gtk_signal_connect(GTK_OBJECT(PaperSelection), "destroy", 
		     GTK_SIGNAL_FUNC(on_destry), NULL);
  gtk_signal_connect (GTK_OBJECT (PaperSelection), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed), NULL);

  gtk_window_set_title (GTK_WINDOW (PaperSelection), 
			_("xgdvi: Paper Selection"));
  gtk_container_set_border_width (GTK_CONTAINER (PaperSelection), 10);

  dialog_vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (PaperSelection), dialog_vbox);
  gtk_widget_show (dialog_vbox);

  frame1 = gtk_frame_new (_("Paper Size"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame1, FALSE, TRUE, 5);
  gtk_widget_show (frame1);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), hbox1);
  gtk_container_border_width (GTK_CONTAINER (hbox1), 5);
  gtk_widget_show (hbox1);

  frame2 = gtk_frame_new (_("Orientation"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), frame2, FALSE, TRUE, 5);
  gtk_widget_show (frame2);
  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame2), hbox2);
  gtk_container_border_width (GTK_CONTAINER (hbox2), 5);
  gtk_widget_show (hbox2);

  paper_optmenu_paper = gtk_option_menu_new ();
  gtk_box_pack_start (GTK_BOX (hbox1), paper_optmenu_paper, TRUE, TRUE, 5);
  gtk_widget_show (paper_optmenu_paper);
  gtk_tooltips_set_tip(gtk_tooltips_new(), paper_optmenu_paper,
    (gchar*) _("Select paper size."),
    (gchar*) NULL);

  PaperSelectionMenu = gtk_menu_new ();
  for (i = 0; MenuItemsPaper[i].label != NULL; i++){
    MenuItemsPaper[i].item
      = gtk_menu_item_new_with_label (MenuItemsPaper[i].label);
    gtk_widget_show (MenuItemsPaper[i].item);
    gtk_menu_append (GTK_MENU (PaperSelectionMenu), MenuItemsPaper[i].item);
  }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (paper_optmenu_paper), 
			    PaperSelectionMenu);

  paper_optmenu_orient = gtk_option_menu_new ();
  gtk_box_pack_start (GTK_BOX (hbox2), paper_optmenu_orient, TRUE, TRUE, 5);
  gtk_widget_show (paper_optmenu_orient);
  gtk_tooltips_set_tip(gtk_tooltips_new(), paper_optmenu_orient,
    (gchar*) _("Select orientation of paper."), 
    (gchar*) NULL);

  OrientSelectionMenu = gtk_menu_new ();
  for (i = 0; MenuItemsOrient[i].label != NULL; i++){
    MenuItemsOrient[i].item 
      = gtk_menu_item_new_with_label (MenuItemsOrient[i].label);
    gtk_widget_show (MenuItemsOrient[i].item);
    gtk_menu_append (GTK_MENU (OrientSelectionMenu), MenuItemsOrient[i].item);
  }
  gtk_option_menu_set_menu (GTK_OPTION_MENU (paper_optmenu_orient), 
			    OrientSelectionMenu);

  gpaper_set(param_paper, 0);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (dialog_vbox), separator, TRUE, TRUE, 0);
  gtk_widget_show (separator);

  achbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(achbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(achbox), 5);
  gtk_box_pack_end (GTK_BOX (dialog_vbox), achbox, TRUE, TRUE, 0);
  gtk_widget_show (achbox);

  psButtonOK = gtk_button_new_with_label (_("Select"));
  GTK_WIDGET_SET_FLAGS (psButtonOK, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (achbox), psButtonOK, TRUE, TRUE, 0);
  gtk_widget_show (psButtonOK);
  gtk_signal_connect (GTK_OBJECT (psButtonOK), "clicked",
                      GTK_SIGNAL_FUNC (on_psButtonOK_clicked),
                      NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), psButtonOK,
    (gchar*) _("Change paper size and orientation."),
    (gchar*) NULL);

  psButtonCancel = gtk_button_new_with_label (_("Close"));
  GTK_WIDGET_SET_FLAGS (psButtonCancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (achbox), psButtonCancel, TRUE, TRUE, 0);
  gtk_widget_grab_default (psButtonCancel);
  gtk_widget_show (psButtonCancel);
  gtk_signal_connect (GTK_OBJECT (psButtonCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_psButtonCancel_clicked),
                      NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), psButtonCancel,
    (gchar*) _("Close the paper selection window."),
    (gchar*) NULL);

  return PaperSelection;
}


static void
on_destry                              (GtkObject       *obj,
                                        gpointer         user_data)
{
  PaperSelectionShown = 0;
  PaperSelection = create_PaperSelection ();
}


void
on_Paper_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  if (PaperSelectionShown == 0){
    PaperSelectionShown = 1;
    gtk_widget_show (PaperSelection);
  } else {
    PaperSelectionShown = 0;
    gtk_widget_hide (PaperSelection);
  }
}


void
show_PaperSelection(void)
{
  if (PaperSelectionShown == 0){
    PaperSelectionShown = 1;
    gtk_widget_show (PaperSelection);
  }
}

void
hide_PaperSelection(void)
{
  if (PaperSelectionShown == 1){
    PaperSelectionShown = 0;
    gtk_widget_hide (PaperSelection);
  }
}


void
on_psButtonOK_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget*  selp;
  GtkWidget*  selo;
  char  *np; 
  int    no, i;

  if (dvi == NULL)
    return;

  np = NULL;
  no = -1;

  selp = gtk_menu_get_active (GTK_MENU (PaperSelectionMenu));
  selo = gtk_menu_get_active (GTK_MENU (OrientSelectionMenu));
  for (i = 0; MenuItemsPaper[i].label != NULL; i++){
    if (MenuItemsPaper[i].item == selp){
      np = MenuItemsPaper[i].label;
      break;
    }
  }
  for (i = 0; MenuItemsOrient[i].label != NULL; i++){
    if (MenuItemsOrient[i].item == selo){
      no = MenuItemsOrient[i].data;
      break;
    }
  }

  if (np != NULL)
    paper  = paper_id(np);
  if (no >= 0)
    orient = no;

  buffer_save_current_state();

  resize_window();
  clear_page();
  ui_cmd     = CMD_DRAW_PAGE;
  page_state = PAGE_EMPTY;
  draw_page();
}


void
on_psButtonCancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  if (PaperSelectionShown == 1){
    PaperSelectionShown = 0;
    gtk_widget_hide (PaperSelection);
  }
}



void
gpaper_set(int pap, int ori)
{
  if ((paper_optmenu_paper == NULL) || (paper_optmenu_orient == NULL))
    return;

  gtk_option_menu_set_history (GTK_OPTION_MENU (paper_optmenu_paper),
			       pap);
  gtk_option_menu_set_history (GTK_OPTION_MENU (paper_optmenu_orient), 
			       ori);
}
