# modes.mf  => Database in C 
# by h.kakugawa

# FMT=0    Text output
# FMT=1    TeX output
# FMT=2    C output


# Start of input

BEGIN {
  if (FMT == 0){
    print "# DEVICE MODE INFORMATION ";
  } else if (FMT == 1){
    print "% DEVICE MODE INFORMATION ";
  } else if (FMT == 2){
    print "/* WARNING!!  NEVER EDIT THIS FILE */";
    print "/* THIS FILE IS AUTOMATICALLY CREATED FROM MODES.MF */";
    print "";
    print "#include defs.h";
    print "struct device_mode_into_struct device_modes[] = {"; 
  }
}


# End of input

END {
  if (FMT == 0){
    print "# END"; 
  } else if (FMT == 1){
    print "% END";    
  } else if (FMT == 2){
    print "  {NULL,-1,-1,NULL}";
    print "};"; 
  }
}



# Line: e.g.,  mode_def ljfour =                       % 600dpi HP LaserJet 4

/^mode_def/ { 
  mode=$2; 
  ppi=-1; 
  ppiv=-1; 
  asp=1.0;
  i=index($0, "%");
  x=substr($0, i);
  desc=substr($0, i + match(x, "[a-zA-Z0-9]") - 1);
}


# Line: e.g.,     mode_param (pixels_per_inch, 600);

/^[ \t]*mode_param[ \t]*\([ \t]*pixels_per_inch, [ \t]*[0-9.]+\);/ {
  match($3, "[0-9.]*");
  ppi=substr($3, 1, RLENGTH);
  ppiv=-1; 
}


### Currently, aspect ratio must be 1

# Line: e.g.,     mode_param (aspect_ratio, 4/3);

/^[ \t]*mode_param[ \t]*\([ \t]*aspect_ratio[ \t]*,[ \t]*[0-9./]+[ \t]*);/ {
  i=match($0, ",[ \t]*");
  s0=i+RLENGTH;
  x=substr($0, s0);
  len=match(x, ")");
  asp=substr($0, s0, len-1);
  ppiv=asp*ppi;
  ppi=-1; ### ignore this entry.
}


# Line: e.g.,   mode_param (aspect_ratio, 180 / pixels_per_inch);

/^[ \t]*mode_param[ \t]*\([ \t]*aspect_ratio, [ \t]*.*\/[ \t]*pixels_per_inch)/ {
  i=match($0, ",[ \t]*[0-9.]");
  x=substr($0, i+RLENGTH-1);
  s0=i+RLENGTH-1;
  match(x, "[ \t]*/");
  ppiv=substr($0, s0, RSTART-1);
  asp=ppi/ppiv;
  ppi=-1; ### ignore this entry.
}


# Line: e.g., enddef;
/^enddef/ {
  if ((mode != "") && (ppi > 0)){
    if (FMT == 0){
     if (ppiv < 0)
        printf("%12s \t%8.2f %8.2f : %s\n", mode, ppi, ppiv, desc); 
    } else if (FMT == 1){
     if (ppiv < 0)
        printf("\\DEVMODE{%s}{%.2f}{%s}\n", mode, ppi, desc); 
    } else if (FMT == 2){
      if (ppiv < 0)
        printf("  {\"%s\",\t\t% 8.2f,\t% 8d,    /* aspect_ratio = 1 */\n", 
        mode, ppi, -1); 
      else
        printf("  {\"%s\",\t\t% 8.2f,\t% 8.2f,    /* aspect_ratio = %.3f */\n", 
        mode, ppi, ppiv, asp); 
      printf("   \"%s\"},\n", desc); 
    }
    mode=""; 
    ppi=-1; 
    ppiv=-1; 
    desc="";
  }
}
