/************************************************************************/
/*  Describes a BMP file.						*/
/************************************************************************/

#   ifndef BMP_H
#   define BMP_H   1

/************************************************************************/
/*  Describes a BMP file.						*/
/************************************************************************/

#define COMPRESS_RGB        0L      /* No compression               */
#define COMPRESS_RLE8       1L      /* 8 bits per pixel compression */
#define COMPRESS_RLE4       2L      /* 4 bits per pixel compression */
#define BMP_ID              0x4d42  /* BMP "magic" number           */

/************************************************************************/
/*  Common information for all kinds of BMP files.			*/
/************************************************************************/
typedef struct BmpFileHeader
    {
			/************************************************/
			/*  Common to all variants.			*/
			/************************************************/
    short	bfhMagic;
    long	bfhFileSize;
    short	bfhReserved1;
    short	bfhReserved2;
    long	bfhBitmapDataOffset;
    long	bfhSizeOfRestOfHeader;	/*  It is the Type of file!	*/
			/************************************************/
			/*  Common to all variants.			*/
			/************************************************/
    long	bfhPixelsWide;
    long	bfhPixelsHigh;
    short	bfhPlanes;
    short	bfhBitsPerPixel;
			/************************************************/
			/*  Common to Windows 3.* and OS/2 2.*		*/
			/************************************************/
    long	bfhCompression;
    long	bfhBufferLength;
    long	bfhXResolution;
    long	bfhYResolution;
    long	bfhColorCount;
    long	bfhImportantColors;
    } BmpFileHeader;

/************************************************************************/
/*  Structures desribing ICO files.					*/
/************************************************************************/
typedef struct IcoFileHeader
    {
    short	ifhReserved;
    short	ifhType;
    short	ifhCount;
    } IcoFileHeader;

typedef struct IcoDirectoryEntry
    {
    unsigned char	ideWidth;
    unsigned char	ideHeight;
    unsigned char	ideColorCount;
    unsigned char	ideReserved;
    short		idePlanes;
    short		ideBitCount;
    long		ideBytesInRes;
    long		ideImageOffset;
    } IcoDirectoryEntry;

#   endif
