/************************************************************************/
/*  Color mangement on X11: Try to get around the limitations.		*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	"appDraw.h"

#   include	<appDebugon.h>

#   ifdef	USE_GTK

/************************************************************************/
/*									*/
/*  Allocate approximate colors.					*/
/*									*/
/************************************************************************/

static int appColorRgb111(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col111= C111( r, g, b );

    if  ( ca->ca222Colors[col111].acAllocated == AC_UNALOCATED )
	{
	APP_COLOR_RGB	xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	g= ( 255* ( g & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;

	if  ( ! gdk_color_alloc( acSys->acColormap, &xc ) )
	    { LDEB(col111); return -1;	}

	ca->ca222Colors[col111].acAllocated= AC_ALOCATED;
	ca->ca222Colors[col111].acRed= xc.red;
	ca->ca222Colors[col111].acGreen= xc.green;
	ca->ca222Colors[col111].acBlue= xc.blue;
	ca->ca222Colors[col111].acColorNumber= xc.pixel;
	}


    *ac= ca->ca222Colors[col111];

    return 0;
    }

static int appColorRgb222(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col222= C222( r, g, b );

    if  ( ca->ca222Colors[col222].acAllocated == AC_UNALOCATED )
	{
	APP_COLOR_RGB	xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	g= ( 255* ( g & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;

	if  ( ! gdk_color_alloc( acSys->acColormap, &xc ) )
	    { LDEB(col222); return -1;	}

	ca->ca222Colors[col222].acAllocated= AC_ALOCATED;
	ca->ca222Colors[col222].acRed= xc.red;
	ca->ca222Colors[col222].acGreen= xc.green;
	ca->ca222Colors[col222].acBlue= xc.blue;
	ca->ca222Colors[col222].acColorNumber= xc.pixel;
	}


    *ac= ca->ca222Colors[col222];
    return 0;
    }

static int appColorRgb555(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col555= C555( r, g, b );

    if  ( ca->caColors[col555].acAllocated == AC_UNALOCATED )
	{
	APP_COLOR_RGB	xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xf1 ) + 0xf1/ 2 )/ 0xf1;
	g= ( 255* ( g & 0xf1 ) + 0xf1/ 2 )/ 0xf1;
	b= ( 255* ( b & 0xf1 ) + 0xf1/ 2 )/ 0xf1;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;

	if  ( ! gdk_color_alloc( acSys->acColormap, &xc ) )
	    {
	    if  ( appColorRgb222( ca->caColors+ col555, ca, r, g, b ) )
		{ LDEB(col555); return -1;	}

	    ca->caColors[col555].acAllocated= AC_COPIED;
	    }
	else{
	    ca->caColors[col555].acAllocated= AC_ALOCATED;
	    ca->caColors[col555].acRed= xc.red;
	    ca->caColors[col555].acGreen= xc.green;
	    ca->caColors[col555].acBlue= xc.blue;
	    ca->caColors[col555].acColorNumber= xc.pixel;
	    }
	}

    *ac= ca->caColors[col555];
    return 0;
    }

static int appColorRgb332(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col332= C332( r, g, b );

    if  ( ca->caColors[col332].acAllocated == AC_UNALOCATED )
	{
	APP_COLOR_RGB	xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xe0 ) + 0xe0/ 2 )/ 0xe0;
	g= ( 255* ( g & 0xe0 ) + 0xe0/ 2 )/ 0xe0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;

	if  ( ! gdk_color_alloc( acSys->acColormap, &xc ) )
	    {
	    if  ( appColorRgb222( ca->caColors+ col332, ca, r, g, b ) )
		{ LDEB(col332); return -1;	}

	    ca->caColors[col332].acAllocated= AC_COPIED;
	    }
	else{
	    ca->caColors[col332].acAllocated= AC_ALOCATED;
	    ca->caColors[col332].acRed= xc.red;
	    ca->caColors[col332].acGreen= xc.green;
	    ca->caColors[col332].acBlue= xc.blue;
	    ca->caColors[col332].acColorNumber= xc.pixel;
	    }
	}

    *ac= ca->caColors[col332];
    return 0;
    }

int appColorRgb(	APP_COLOR_RGB *		xc,
			AppColors *		acSys,
			unsigned int		r,
			unsigned int		g,
			unsigned int		b )
    {
    AllocatorColor	ac;
    ColorAllocator *	ca= &(acSys->acAllocator);

    if  ( acSys->acVisualClass ==	GDK_VISUAL_TRUE_COLOR	||
	  acSys->acVisualClass ==	GDK_VISUAL_DIRECT_COLOR	)
	{
	bmColorRgbDirect( &ac, ca, r, g, b );
	}
    else{
	if  ( ! ca->caSystemAllocator )
	    { XDEB(ca->caSystemAllocator); return -1;	}

	if  ( (*ca->caSystemAllocator)( &ac, ca, r, g, b ) )
	    { LLLDEB(r,g,b); return -1;	}
	}

    xc->red= ac.acRed;
    xc->green= ac.acGreen;
    xc->blue= ac.acBlue;
    xc->pixel= ac.acColorNumber;

    return 0;
    }

int appColorNamed(	APP_COLOR_RGB *		xc,
			AppColors *		acSys,
			const char *		name )
    {
    APP_COLOR_RGB	exact;

    if  ( ! gdk_color_parse( name, &exact ) )
	{ SDEB(name); return -1;	}

    return appColorRgb( xc, acSys,
			exact.red/257, exact.green/257, exact.blue/257 );
    }

int appAllocateColors(	AppDrawingData *	add,
			AppColors *		acSys )
    {
    GdkVisual *		vis= gdk_visual_get_system();
    GdkColormap *	cmap= gdk_colormap_get_system();

    int			count;
    int			i;

    ColorAllocator *	ca= &(acSys->acAllocator);

    acSys->acColormap= cmap;
    acSys->acVisualClass= vis->type;

    ca->caSystemPrivate= acSys;
    ca->caDepth= vis->depth;

    switch( acSys->acVisualClass )
	{
	case GDK_VISUAL_STATIC_GRAY:
	case GDK_VISUAL_GRAYSCALE:
	    ca->caAllocationType= AC_ALOCATED;
	    switch( ca->caDepth )
		{
		case 1: case 2: case 4: case 8:
		    break;
		default:
		    LLDEB(acSys->acVisualClass,ca->caDepth);
		}
	    break;

	case GDK_VISUAL_STATIC_COLOR:
	    ca->caAllocationType= AC_ALOCATED;
	    break;

	case GDK_VISUAL_PSEUDO_COLOR:
	    ca->caAllocationType= AC_ALOCATED;
	    break;

	case GDK_VISUAL_TRUE_COLOR:
	case GDK_VISUAL_DIRECT_COLOR:
	    ca->caAllocationType= AC_CALCULATED;

	    bmSetCalculatedShifts( ca, vis->red_mask,
					    vis->green_mask, vis->blue_mask );

	    return 0;
	}

    switch( vis->depth )
	{
	case  1:
	    count= 2;
	    ca->caSystemAllocator= appColorRgb111;
	    break;

	case  2:
	    count= 4;
	    ca->caSystemAllocator= appColorRgb111;
	    break;
	case  4:
	    count= 16;
	    ca->caSystemAllocator= appColorRgb222;
	    break;

	case  8:
	    count= 256;
	    ca->caSystemAllocator= appColorRgb332;
	    break;

	case 16:
	    count= 256* 256;
	    ca->caSystemAllocator= appColorRgb555;
	    break;

	case 24:
	case 32:
	    return 0;

	default:
	    LDEB(vis->depth); return -1;
	}

    ca->caColors= (AllocatorColor *)malloc( count* sizeof(AllocatorColor) );

    if  ( ! ca->caColors )
	{ LXDEB(count,ca->caColors); return -1;	}

    ca->caColorCount= count;

    for ( i= 0; i < count; i++ )
	{
	ca->caColors[i].acColorNumber= 0;
	ca->caColors[i].acAllocated= AC_UNALOCATED;
	}

    return 0;
    }

void appCleanColors(	AppColors *		acSys )
    {
    int			i;

    GdkColormap *	cmap= acSys->acColormap;
    ColorAllocator *	ca= &(acSys->acAllocator);

    for ( i= 0; i < 64; i++ )
	{
	if  ( ca->ca222Colors[i].acAllocated == AC_ALOCATED )
	    {
	    gulong	pix= ca->ca222Colors[i].acColorNumber;

	    gdk_colors_free( cmap, &pix, 1, 0L );
	    ca->ca222Colors[i].acAllocated= AC_UNALOCATED;
	    }
	}

    for ( i= 0; i < ca->caColorCount; i++ )
	{
	if  ( ca->caColors[i].acAllocated == AC_ALOCATED )
	    {
	    gulong	pix= ca->caColors[i].acColorNumber;

	    gdk_colors_free( cmap, &pix, 1, 0L );
	    ca->caColors[i].acAllocated= AC_UNALOCATED;
	    }
	}

    bmCleanColorAllocator( ca );
    }

void appInitColors(	AppColors *	acSys )
    {
    ColorAllocator *	ca= &(acSys->acAllocator);

    bmInitColorAllocator( ca );

    acSys->acColormap= (GdkColormap *)0;
    }

int appColorFindRgb(	APP_COLOR_RGB *	xc,
			AppColors *	acSys,
			unsigned int	r,
			unsigned int	g,
			unsigned int	b )
    {
    ColorAllocator *	ca= &(acSys->acAllocator);
    int			d;
    int			col;

    for ( d= 0; d < 128; d++ )
	{
	AllocatorColor *	ac;

	ac= ca->ca222Colors;
	for ( col= 0; col < 64; ac++, col++ )
	    {
	    if  ( ac->acAllocated == AC_UNALOCATED )
		{ continue;	}

	    if  ( ac->acRed	> 256* ( r- d )		&&
		  ac->acRed	< 256* ( r+ d )		&&
		  ac->acGreen	> 256* ( g- d )		&&
		  ac->acGreen	< 256* ( g+ d )		&&
		  ac->acBlue	> 256* ( b- d )		&&
		  ac->acBlue	< 256* ( b+ d )		)
		{
		xc->red= ac->acRed;
		xc->green= ac->acGreen;
		xc->blue= ac->acBlue;
		xc->pixel= ac->acColorNumber;

		return 0;
		}
	    }

	ac= ca->caColors;
	for ( col= 0; col < ca->caColorCount; ac++, col++ )
	    {
	    if  ( ac->acAllocated == AC_UNALOCATED )
		{ continue;	}

	    if  ( ac->acRed	> 256* ( r- d )		&&
		  ac->acRed	< 256* ( r+ d )		&&
		  ac->acGreen	> 256* ( g- d )		&&
		  ac->acGreen	< 256* ( g+ d )		&&
		  ac->acBlue	> 256* ( b- d )		&&
		  ac->acBlue	< 256* ( b+ d )		)
		{
		xc->red= ac->acRed;
		xc->green= ac->acGreen;
		xc->blue= ac->acBlue;
		xc->pixel= ac->acColorNumber;

		return 0;
		}
	    }
	}

    return -1;
    }

#   endif
