/************************************************************************/
/*									*/
/*  Paragraph properties.						*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PARA_PROP_H
#   define	DOC_PARA_PROP_H

#   include	<docFont.h>
#   include	"utilPropMask.h"
#   include	"docPropVal.h"
#   include	"docBorderProperties.h"
#   include	"docParaNumber.h"
#   include	"docFrameProperties.h"

/************************************************************************/
/*									*/
/*  Describes tabs.							*/
/*									*/
/*  !)	RS6000/AIX compler only supports unsigned bitfields.		*/
/*									*/
/************************************************************************/

typedef enum TabAlignment
    {
    DOCtaLEFT= 0,

    DOCtaRIGHT,
    DOCtaCENTRE,
    DOCtaDECIMAL,

    DOCtaBAR,

    DOCta_COUNT
    } TabAlignment;

typedef enum TabLeader
    {
    DOCtlNONE= 0,

    DOCtlDOTS,
    DOCtlUNDERLINE,
    DOCtlHYPH,

    DOCtlTHICK,
    DOCtlEQUAL,

    DOCtl_COUNT
    } TabLeader;

typedef struct TabStop
    {
    int			tsTwips;
    int			tsPixels;
    unsigned int	tsAlignment:8;	/*  (enum)	*/
    unsigned int	tsLeader:8;	/*  (enum)	*/
    } TabStop;

/************************************************************************/
/*									*/
/*  Paragraph properties.						*/
/*									*/
/*  Unless explicitly stated, all properties except numbers in pixels	*/
/*  are properties of the paragraph.					*/
/*									*/
/*  1)  Tab stops.							*/
/*  2)  Indentations.							*/
/*  3)  White space above/after the paragraph.				*/
/*  4)  Style.								*/
/*  5)  Borders.							*/
/*									*/
/************************************************************************/

typedef struct ParagraphProperties
    {
    /*  1  */
    TabStop *		ppTabStops;
    short int		ppTabCount;

    /*  2  */
    short int		ppFirstIndentTwips;
    short int		ppLeftIndentTwips;
    short int		ppRightIndentTwips;

    /*  3  */
    short int		ppSpaceBeforeTwips;
    short int		ppSpaceAfterTwips;
    short int		ppLineSpacingTwips;

    /*  4  */
    short int		ppStyle;

    /*  5  */
    BorderProperties	ppTopBorder;
    BorderProperties	ppBottomBorder;
    BorderProperties	ppLeftBorder;
    BorderProperties	ppRightBorder;
    BorderProperties	ppBetweenBorder;
    BorderProperties	ppBoxBorder;
    BorderProperties	ppBar;

    unsigned int	ppOutlineLevel:4;

    unsigned int	ppShadingLevel:10;
    unsigned int	ppShadingPattern:4;		/*  (enum)	*/

    unsigned int	ppAlignment:3;			/*  (enum)	*/

    unsigned int	ppStartsOnNewPage:1;
    unsigned int	ppInTable:1;
    unsigned int	ppLineSpacingIsMultiple:1;

    unsigned int	ppKeepOnPage:1;
    unsigned int	ppKeepWithNext:1;
    unsigned int	ppWidowControl:1;
    unsigned int	ppHyphenateParagraph:1;

    short int		ppShadingForeground;
    short int		ppShadingBackground;
    } ParagraphProperties;

/************************************************************************/
/*									*/
/*  Numbers and Masks for updating paragraph properies.			*/
/*									*/
/************************************************************************/

typedef enum ParagraphProperty
    {
    PPprop_NONE= -1,

    PPpropSTYLE= 0,
    PPpropIN_TABLE,
    PPpropLEFT_INDENT,
    PPpropFIRST_INDENT,
    PPpropRIGHT_INDENT,
    PPpropALIGNMENT,
    PPpropTAB_STOPS,
    PPpropNEWPAGE,
    PPpropWIDCTLPAR,
    PPpropKEEP,
    PPpropKEEPN,
    PPpropSPACE_BEFORE,
    PPpropSPACE_AFTER,
    PPpropLINE_SPACING_DIST,
    PPpropLINE_SPACING_MULT,
    PPpropTOP_BORDER,
    PPpropBOTTOM_BORDER,
    PPpropOUTLINELEVEL,
    PPpropHYPHPAR,
    PPpropSHADING_LEVEL,
    PPpropSHADING_PATTERN,
    PPpropSHADING_FOREGROUND,
    PPpropSHADING_BACKGROUND,

    PPpropCOLUMNS,			/*  Not a real property.	*/
					/*  But used for managing the	*/
					/*  ruler of a document window.	*/

    PPprop_COUNT
    } ParagraphProperty;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitTabStop(	TabStop *		ts );

extern int docParaAddTab(	ParagraphProperties *	pp,
				const TabStop *		tsNew );

extern void docParaDeleteTab(	ParagraphProperties *	pp,
				int			n );

extern int docUpdParaProperties( PropertyMask *			pPpChgPask,
				ParagraphProperties *		pp,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew );

extern void docParaPropertyDifference(
				PropertyMask *			pChgMask,
				const ParagraphProperties *	pp1,
				const ParagraphProperties *	pp2,
				const PropertyMask *		updMask );

extern void docCleanParagraphProperties(	ParagraphProperties *	pp );

extern void docInitParagraphProperties(		ParagraphProperties *	pp );

#   endif	/*  DOC_PARA_PROP_H	*/
