/************************************************************************/
/*									*/
/*  Document Editing.							*/
/*									*/
/************************************************************************/

#   ifndef		DOC_EDIT_H
#   define		DOC_EDIT_H

#   include		"docBuf.h"

/************************************************************************/
/*									*/
/*  Describes an edit operation. Part is only used for interactive edit	*/
/*  operations.								*/
/*									*/
/************************************************************************/

typedef struct EditPosition
    {
    int		epParagraphNumber;
    int		epStroff;
    } EditPosition;

typedef struct EditRange
    {
    int			erParagraphCount;
    int			erBottomLevel;
    EditPosition	erStartPosition;
    EditPosition	erEndPosition;
    } EditRange;

typedef struct EditOperation
    {
    SelectionScope	eoSelectionScope;

    DocumentRectangle	eoChangedRectangle;
    int			eoOldBackY1;

    int			eoIBarSelectionOld;
    int			eoMultiParagraphSelectionOld;

    /**/
    int			eoParaAdjustParagraphNumber;
    int			eoParaAdjustFromLine;
    int			eoParaAdjustStroffShift;
    int			eoParaAdjustStroffUpto;

    /**/
    EditRange		eoReformatRange;

    /**/
    int			eoNotesDeleted;
    int			eoNotesAdded;
    int			eoParagraphsDeleted;
    int			eoParagraphsInserted;

    unsigned int	eoFieldUpdate;

    /**/
    BufferDocument *	eoBd;
    void *		eoVoidadd;
    DOC_CLOSE_OBJECT	eoCloseObject;
    } EditOperation;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern int docParaReplaceText(	EditOperation *		eo,
				BufferItem *		bi,
				int			part,
				unsigned int		stroffBegin,
				int *			pPartShift,
				int *			pStroffShift,
				unsigned int		stroffEnd,
				const unsigned char *	addedText,
				unsigned int		addedLength,
				TextAttribute		addedAttribute );

extern int docSplitParaItem(	BufferDocument *	bd,
				BufferItem **		pNewBi,
				BufferItem *		oldBi,
				int			stroff );

extern int docRemoveSelectionTail(
				EditOperation *			eo,
				const DocumentSelection *	ds );

extern void docEditDeleteItems(		EditOperation *		eo,
					BufferItem *		bi,
					int			first,
					int			count );

extern void docCloseItemObjects(	int *			pNoteCount,
					int *			pParagraphCount,
					BufferDocument *	bd,
					BufferItem *		bi,
					void *			voidadd,
					DOC_CLOSE_OBJECT	closeObject );

extern TextParticule * docParaSpecialParticule(	BufferItem *	bi,
					int			kind,
					int			part,
					int			stroff,
					int *			pPartShift,
					int *			pStroffShift );

extern int docReplaceSelection(
			EditOperation *			eo,
			const DocumentSelection *	bs,
			int *				pPartShift,
			int *				pStroffShift,
			const unsigned char *		addedText,
			int				addedLength,
			TextAttribute			addedAttribute );

extern void docInitEditOperation(	EditOperation *	eo );
extern void docInitEditPosition(	EditPosition *	ep );
extern void docInitEditRange(		EditRange *	er );

extern void docIncludePositionInReformat(
					EditOperation *		eo,
					const BufferItem *	paraBi,
					int			stroff );

extern void docEditIncludeItemInReformatRange(	EditOperation *		eo,
						BufferItem *		bi );


extern void docEditShiftReformatRangeParaNr(
					EditOperation *		eo,
					int			from,
					int			by );

extern void docSetParagraphAdjust(	EditOperation *		eo,
					BufferItem *		paraBi,
					int			fromLine,
					int			stroffShift,
					int			stroffUpto );

extern void docExtendParagraphAdjust(	EditOperation *		eo,
					BufferItem *		paraBi,
					int			stroffShift );

extern int docEditMakeParagraphEmpty(	BufferItem *		paraBi,
					EditOperation *		eo );

#   endif	/*	DOC_EDIT_H	*/
