/***************************************************************************
                          tea_findfiles.c  -  description
                             -------------------
    begin                :
    copyright            : (C) 2006 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <stdlib.h> // needed for system

#include "tea_defs.h"
#include "tea_text_document.h"
#include "interface.h"
#include "tea_gtk_utils.h"
#include "tea_config.h"
#include "tea_funx.h"
#include "rox_strings.h"
#include "tea_findfiles_mult.h"
#include "tea_tree_view.h" // Needed for tv_get_selected_single


static void find_in_files_free (t_find_in_files_mult *instance)
{
  dbm ("find_in_files_free");
  g_free (instance);
}


static gboolean on_find_in_files_delete_event (GtkWidget *widget, GdkEvent *event,
                                               gpointer user_data)
{
  find_in_files_free (user_data);
  return FALSE;
}


static gboolean on_find_in_files_key_press_event (GtkWidget *widget,
                                           GdkEventKey *event,
                                           gpointer user_data)
{
  if (event->keyval == GDK_Escape)
    {
     find_in_files_free (user_data);
     gtk_widget_destroy (widget);
     return TRUE;
    }

  return FALSE;
}


static gboolean pb_bounce (gpointer data)
{
  t_find_in_files_mult *p = data;
  gtk_progress_bar_pulse (p->pb_progress_bar);
  return TRUE;
}


static void pb_start (t_find_in_files_mult *p)
{
  p->id_pb = g_timeout_add (100, p->pb_progress_bar, NULL);
  gtk_widget_show (p->pb_progress_bar);
  gtk_progress_bar_pulse (p->pb_progress_bar);
}


static void pb_stop (t_find_in_files_mult *p)
{
  gtk_progress_bar_set_fraction (p->pb_progress_bar, 0.0);
  g_source_remove (p->id_pb);
  gtk_widget_hide (p->pb_progress_bar);
}


static gint button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  t_find_in_files_mult *p = user_data;

  if (event->button == 1)
     if (event->type == GDK_2BUTTON_PRESS)
        {
         gchar *s = tv_get_selected_single (p->tv_found_files);
         if (s)
            {
             gchar *l = get_l_filename (s);
             execute_recent_item (l);
             g_free (l);
             return TRUE;
            }
         }
  return FALSE;
}


static GList* find_in_files (t_find_in_files_mult *instance, GList *files, const gchar *s_and, const gchar *s_or, const gchar *s_not)
{
  if (! s_and)
     return NULL;

  pb_start (instance);

  GList *result = NULL;

  GList *l = g_list_first (files);
  GList *l_and = glist_from_string (s_and);
  GList *l_or = glist_from_string (s_or);

  GList *l_not = glist_from_string (s_not);
  GList *x_or;
  GList *x_and;
  GList *x_not;

  gboolean flag = FALSE;

  gchar *t = NULL;

  while (l)
        {
         flag = FALSE;
         gtk_progress_bar_set_text (instance->pb_progress_bar, l->data);
         gtk_progress_bar_pulse (instance->pb_progress_bar);

         x_not = g_list_first (l_not);

         while (x_not)
               {
                if (! is_office (l->data))
                   t = strinfile (l->data, x_not->data);
                else
                    t = strinfile_office (l->data, x_not->data);

                if (t)
                   {
                    g_free (t);
                    flag = TRUE;

                    break;
                   }

                x_not = g_list_next (x_not);
               }

         if (flag)
           {
            l = g_list_next (l);
            continue;
           }

         x_and = g_list_first (l_and);

         while (x_and)
               {
                if (! is_office (l->data))
                   t = strinfile (l->data, x_and->data);
                else
                    t = strinfile_office (l->data, x_and->data);

                if (! t)
                   {
                    flag = TRUE;
                    break;
                   }

                result = g_list_prepend (result, t);
                x_and = g_list_next (x_and);
               }


         if (flag)
           {
            l = g_list_next (l);
            continue;
           }

         x_or = g_list_first (l_or);

         while (x_or)
               {
                if (! is_office (l->data))
                   t = strinfile (l->data, x_or->data);
                else
                    t = strinfile_office (l->data, x_or->data);

                if (t)
                   {
                    result = g_list_prepend (result, t);
                    break;
                   }

                x_or = g_list_next (x_or);
               }


         if (flag)
           {
            l = g_list_next (l);
            continue;
           }

         result = g_list_prepend (result, recent_item_compose (l->data, "UTF-8!", 0));

         l = g_list_next (l);
        }

  pb_stop (instance);

  glist_strings_free (l_and);
  glist_strings_free (l_not);
  glist_strings_free (l_or);

  return result;
}


static void on_button_copy_to_dir (GtkWidget *wid, gpointer data)
{
  t_find_in_files_mult *instance = data;

  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Select a directory"), NULL,                                                             GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,                                                      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                  GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gchar *filename = NULL;

  if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)
     filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  else
      {
       gtk_widget_destroy (dialog);
       return;
      }

  gtk_widget_destroy (dialog);

  GList *l = tv_get_list_data (instance->tv_found_files);
  gchar *x = NULL;
  gchar *f = NULL;

  gchar *cm = NULL;
  while (l)
        {
         x = str_before_sep (l->data, ",");
         f = get_l_filename (x);

         cm = g_strconcat ("cp --reply=yes ", f, " ", filename, NULL);
      //   dbm (file_replace_path (f, filename));

         system (cm);

         g_free (x);
         g_free (cm);
         g_free (f);

         l = g_list_next (l);
        }
}


static void on_button_find (GtkWidget *wid, gpointer data)
{
  t_find_in_files_mult *instance = data;

  gchar *dir = gtk_entry_get_text (instance->ent_dir_where_to_find);
  if (! dir)
      return;

  GError *error = NULL;
  gl_found_files = NULL;

  pb_start (instance);

  read_dir_files_recurse (dir, gtk_entry_get_text (instance->ent_pattern));

  pb_stop (instance);

  gtk_widget_show (instance->ffstatusbar);

  GList *lx = find_in_files (instance, gl_found_files,
                             get_text_buf (gtk_text_view_get_buffer (instance->txv_and)),
                             get_text_buf (gtk_text_view_get_buffer (instance->txv_or)),
                             get_text_buf (gtk_text_view_get_buffer (instance->txv_not))
                            );

  tv_fill_with_glist (instance->tv_found_files, lx);

  glist_strings_free (lx);
}


static void on_button_savesession (GtkWidget *wid, gpointer data)
{
  t_find_in_files_mult *instance = data;

  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("File save"), NULL, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                  GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), confile.sessions_dir);

   gchar *filename = NULL;

  if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)
     filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  else
      return;

  gtk_widget_destroy (dialog);

  GList *l = tv_get_list_data (instance->tv_found_files);
  GList *save = NULL;
  while (l)
        {
         save = g_list_prepend (save, get_l_filename (l->data));
         l = g_list_next (l);
        }

  glist_save_to_file (save, filename);
  glist_strings_free (save);
  reload_sessions ();
}


GtkWidget* create_findfiles_mult (void)
{
  GtkWidget *frame_and_strings;
  GtkWidget *frame_not_strings;
  GtkWidget *frame_or_strings;

  t_find_in_files_mult *instance = g_malloc (sizeof (t_find_in_files_mult));
  gl_found_files = NULL;

  GtkWidget *window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window1), _("Find in files"));

  instance->vbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (instance->vbox1);
  gtk_container_add (GTK_CONTAINER (window1), instance->vbox1);

  GtkWidget *box_frames = gtk_hbox_new (TRUE, UI_PACKFACTOR);
  gtk_widget_show (box_frames);
  gtk_box_pack_start (GTK_BOX (instance->vbox1), box_frames, TRUE, TRUE, UI_PACKFACTOR);

  frame_and_strings = gtk_frame_new (_("And:"));
  frame_or_strings = gtk_frame_new (_("Or:"));
  frame_not_strings = gtk_frame_new (_("Not:"));

  instance->txv_and = gtk_text_view_new ();
  gtk_widget_show (instance->txv_and);
  instance->txv_or = gtk_text_view_new ();
  gtk_widget_show (instance->txv_or);
  instance->txv_not = gtk_text_view_new ();
  gtk_widget_show (instance->txv_not);

  GtkWidget *scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolledwindow);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), instance->txv_and);
  gtk_container_add (GTK_CONTAINER (frame_and_strings), scrolledwindow);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolledwindow);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), instance->txv_or);
  gtk_container_add (GTK_CONTAINER (frame_or_strings), scrolledwindow);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolledwindow);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), instance->txv_not);
  gtk_container_add (GTK_CONTAINER (frame_not_strings), scrolledwindow);


  gtk_box_pack_start (GTK_BOX (box_frames), frame_and_strings, TRUE, TRUE, UI_PACKFACTOR);
  gtk_box_pack_start (GTK_BOX (box_frames), frame_or_strings, TRUE, TRUE, UI_PACKFACTOR);
  gtk_box_pack_start (GTK_BOX (box_frames), frame_not_strings, TRUE, TRUE, UI_PACKFACTOR);

  gtk_widget_show (frame_and_strings);
  gtk_widget_show (frame_or_strings);
  gtk_widget_show (frame_not_strings);

  instance->hbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (instance->hbox1);
  gtk_box_pack_start (GTK_BOX (instance->vbox1), instance->hbox1, TRUE, TRUE, UI_PACKFACTOR);


/*
  gchar *ft = get_clipboard_text ();

  if (ft)
      gtk_entry_set_text (instance->ent_text_to_find, g_strstrip (ft));

  g_free (ft);
*/
  instance->ent_dir_where_to_find = tea_dir_selector (instance->hbox1, _("And where to find?"), g_get_home_dir ());

  instance->ent_pattern = tea_text_entry (instance->hbox1, _("File pattern"), "*.txt");

  GtkWidget *hbox4 = gtk_hbox_new (TRUE, UI_PACKFACTOR);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (instance->vbox1), hbox4, FALSE, FALSE, UI_PACKFACTOR);

  GtkWidget *bt_find = gtk_button_new_with_label (_("Find"));
  gtk_widget_show (bt_find);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_find, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_find, "clicked",
                    G_CALLBACK (on_button_find),
                    instance);

  GtkWidget *bt_copy_to_dir = gtk_button_new_with_label (_("Copy to the directory"));
  gtk_widget_show (bt_copy_to_dir);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_copy_to_dir, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_copy_to_dir, "clicked",
                    G_CALLBACK (on_button_copy_to_dir),
                    instance);

  GtkWidget *bt_savesession = gtk_button_new_with_label (_("Save as a session"));
  gtk_widget_show (bt_savesession);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_savesession, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_savesession, "clicked",
                    G_CALLBACK (on_button_savesession),
                    NULL);

  GtkWidget *hbox3 = gtk_hbox_new (TRUE, UI_PACKFACTOR);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (instance->vbox1), hbox3, FALSE, TRUE, UI_PACKFACTOR);

  instance->tv_found_files = tv_create_framed (instance->hbox1, _("Found files"), GTK_SELECTION_SINGLE);

  g_signal_connect (GTK_OBJECT (instance->tv_found_files), "button_press_event",
                     (GtkSignalFunc) button_press_event, instance);

  instance->ffstatusbar = gtk_statusbar_new ();
  gtk_widget_show (instance->ffstatusbar);
  gtk_box_pack_start (GTK_BOX (instance->vbox1), instance->ffstatusbar, FALSE, FALSE, UI_PACKFACTOR);

  //b.p. Scorn - Whine - Strand

  instance->pb_progress_bar = gtk_progress_bar_new ();
  gtk_box_pack_start (GTK_BOX (instance->ffstatusbar), instance->pb_progress_bar, FALSE, FALSE, UI_PACKFACTOR);
  gtk_progress_bar_set_pulse_step (instance->pb_progress_bar, 0.05);
  gtk_widget_show (instance->ffstatusbar);

//  gtk_window_set_focus (window1, instance->ent_text_to_find);

  gtk_window_resize (window1, get_value (confile.screen_w, 80), get_value (confile.screen_h, 80));

  g_signal_connect (window1, "key_press_event",
                    G_CALLBACK (on_find_in_files_key_press_event),
                    instance);

  g_signal_connect (window1, "delete_event",
                    G_CALLBACK (on_find_in_files_delete_event),
                    instance);

  gtk_window_set_position (window1, GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_widget_show (window1);

  return window1;
}
