//
// C++ Implementation: filehandler
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filehandler.h"

fileHandler::fileHandler()
{
}

fileHandler::~fileHandler()
{
}

int	fileHandler::readFromSWS(QFile * file, APList * list)
{  // Doesn't delete neither file nor list

APEntry * ap = 0;
int i=0, j=0;

cout << "Parsing file: " << file->name() << endl;
if (!file->open( IO_ReadOnly ))
{
	KMessageBox::error(0, i18n("Error while opening '%1' for reading: ").arg(file->name()) + file->errorString());
	return -1;
}

QTextStream stream( file );
QString line = stream.readLine();	// Read only the first line
QString fileContent;
QDomDocument xmlTree;
bool result = FALSE;

if (line.contains("xml version") > 0)
{
	result = xmlTree.setContent( file ); // Directly parse the file
}
else
{
	// Old format, warning to instance people to upgrade version
	cout << "Parsing old version .sws file. Please, re-save it once opened to convert it to new versions." << endl;
	QMessageBox::warning(0, QString::null, i18n("This is an old version .sws file. Please, re-save it once opened to convert it to new versions."));
	// Old versions "xml" format. Need to be adapted first:
	fileContent = stream.read();
	// add some xml stuff:
	fileContent.prepend("<row>\n");
	fileContent.prepend("<swscanner>\n");
	fileContent.prepend("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
	fileContent.append("</swscanner>\n");
	result = xmlTree.setContent( fileContent ); // Parse the modified QString
}

// Error handling
if ( !result )
{
	KMessageBox::error( 0, i18n( "Parsing error for file '%1'" ).arg( file->name() ) );
	file->close();
	return -2;
}

KProgressDialog prog;
prog.setInitialSize(QSize(200, 100));
prog.setAllowCancel(TRUE);
prog.setModal(TRUE);
prog.setMinimumDuration(500);	// Wait 0,5 sec. until the progressbar appears. Good for quick processings.

if (xmlTree.elementsByTagName("ROW").count() > 0 )	// New format (real xml)
{
	QDomNodeList rows = xmlTree.elementsByTagName("ROW");
	prog.progressBar()->setTotalSteps(rows.count());
	for (i = 0; i < (int)rows.count(); i++)
	{
		prog.progressBar()->setProgress( i );
		prog.setLabel( i18n("Parsing file") + QString("... [%1 - %2]").arg(i).arg(rows.count()) );
		qApp->processEvents();
		if ( prog.wasCancelled() )
			break;
		ap = new APEntry();
		#if SWSDEBUG
		cout << "Parsing new row..." << endl;
		#endif
		QDomNodeList attribs = rows.item(i).childNodes();
		ap->reset();
		for (j = 0; j < (int)attribs.count(); j++)
		{
			QDomElement e = attribs.item(j).toElement();
			if ( !e.isNull() )
			{
				if (e.tagName() == "ESSID")
					ap->setEssid( (char*)e.text().stripWhiteSpace().ascii() );
				else if (e.tagName() == "MAC")
					ap->setMAC( (char*)e.text().stripWhiteSpace().ascii() );
				else if (e.tagName() == "VENDOR")
					ap->setVendor( (char*)e.text().stripWhiteSpace().ascii() );
				else if (e.tagName() == "WEP")
					ap->setWEP( (e.text().stripWhiteSpace() == "1") );
				else if (e.tagName() == "CHANNEL")
					ap->setChannel( e.text().stripWhiteSpace().toInt() );
				else if (e.tagName() == "MODE")
					ap->setMode( (e.text().stripWhiteSpace() == "master") ? 0 : 1 );
				else if (e.tagName() == "SIGNAL_MAX")
				{
					ap->setSignalMax( e.text().stripWhiteSpace().toInt() );
					ap->setSignal( ap->getSignalMax() ); // Also sets the signal, although may not be necessary
				}
				else if (e.tagName() == "SNR_MAX")
				{
					ap->setSNRMax( e.text().stripWhiteSpace().toInt() );
					ap->setNoise( ap->getSignal() - ap->getSNRMax() );
				}

				#if SWSDEBUG
				cout << "====> Parsed: [" << e.tagName() << " " << e.text() << "]" << endl;
				#endif
			}
		}
		list->append(ap);
	}
	prog.progressBar()->setProgress( rows.count() );
}
else
{
	QDomNodeList rows = xmlTree.elementsByTagName("row");
	prog.progressBar()->setTotalSteps(rows.count());
	for (i = 0; i < (int)rows.count(); i++)
	{
		prog.progressBar()->setProgress( i );
		prog.setLabel( i18n("Parsing file") + QString("... [%1 - %2]").arg(i).arg(rows.count()) );
		qApp->processEvents();
		if ( prog.wasCancelled() ) 
			break;
		ap = new APEntry();
		#if SWSDEBUG
		cout << "Parsing new row..." << endl;
		#endif
		QDomElement e = rows.item(i).toElement();
		ap->reset();
		if (!e.isNull())
		{
			ap->setEssid( (char*) e.text().section('\n', 2, 2).stripWhiteSpace().ascii() );
			ap->setMAC( (char*) e.text().section('\n', 3, 3).stripWhiteSpace().ascii() );
			ap->setVendor( (char *)AccessPointListView::getVendor( e.text().section('\n', 3, 3).stripWhiteSpace() ).ascii() );
			ap->setChannel ( e.text().section('\n', 4, 4).toInt() );
			ap->setMode ( (e.text().section('\n', 5, 5).stripWhiteSpace() == "master" ? 0 : 1 ) );
			ap->setWEP ( (e.text().section('\n', 11, 11).stripWhiteSpace() == "YES") );
			ap->setSignal ( e.text().section('\n', 7, 7).toInt() );
			ap->setSignalMax(ap->getSignal());
			ap->setNoise ( e.text().section('\n', 8, 8).toInt() );
			ap->setSNRMax( ap->getSignal() - ap->getNoise() );

			list->append(ap);

			#if SWSDEBUG
			cout << "====> Parsed: ESSID ["   << e.text().section('\n', 2, 2)   << "]" << endl;
			cout << "====> Parsed: MAC ["     << e.text().section('\n', 3, 3)   << "]" << endl;
			cout << "====> Parsed: CHANNEL [" << e.text().section('\n', 4, 4)   << "]" << endl;
			cout << "====> Parsed: MODE ["    << e.text().section('\n', 5, 5)   << "]" << endl;
			cout << "====> Parsed: SIGNAL ["  << e.text().section('\n', 7, 7)   << "]" << endl;
			cout << "====> Parsed: NOISE ["   << e.text().section('\n', 8, 8)   << "]" << endl;
			cout << "====> Parsed: WEP ["     << e.text().section('\n', 11, 11) << "]" << endl;
			#endif
		}
	}
	prog.progressBar()->setProgress( rows.count() );
}

return 0;
}

int	fileHandler::readFromSWL(QFile * file, APList * list)
{  // Doesn't delte neither file nor list
// NSS and SWL files have the same form. The only difference is that
//SWL files have duplicate lines and NSS doesn't	
return readFromNSF(file, list);
}

int	fileHandler::readFromNSF(QFile * file, APList * list)
{  // Doesn't delte neither file nor list

int i=0, j=0, k=0;
QTextStream stream( file );
QString line;
APEntry * ap;
char temp[18];
float lati, longi;

cout << "Parsing file: " << file->name() << endl;
if (!file->open( IO_ReadOnly ))
{
	KMessageBox::error(0, i18n("Error while opening '%1' for reading: ").arg(file->name()) + file->errorString());
	return -1;
}

// Count lines of the file:
while ( !stream.atEnd() ) 
{
	if (stream.readLine().left(1) != "#")	// Do not count commented lines
		j++;
}

KProgressDialog prog;
prog.setInitialSize(QSize(200, 100));
prog.setAllowCancel(TRUE);
prog.setModal(TRUE);
prog.setMinimumDuration(1000);	// Wait 1 sec. until the progressbar appears. Good for quick processings.
prog.progressBar()->setTotalSteps( j );

file->reset();	// Rewind the file pointer
while ( !stream.atEnd() ) 
{
	line=stream.readLine();
	k=0;
	if (line.left(1) != "#")
	{
		prog.progressBar()->setProgress( i );
		prog.setLabel( i18n("Parsing file") + QString("... [%1 - %2]").arg(i).arg( j ) );
		qApp->processEvents();
		if ( prog.wasCancelled() ) 
			break;
		ap = new APEntry;
		QStringList data = data.split("\t", line, TRUE);
		for ( QStringList::Iterator it = data.begin(); it != data.end(); ++it) 
		{
			//qDebug(QVariant((uint)data.count()).toString());
			if (data.count() != 13) 
			{
				KMessageBox::error( 0, i18n( "Parsing error for file '%1'" ).arg( file->name() ) );
				file->close();
				return -2;
			}
			switch (k) 
			{
			case 0: lati=QVariant((*it).right((*it).length()-2)).toDouble(); 
				if ((*it).left(1) == "S") lati = -lati;		// lati is northern
				ap->setLatitude(lati);
				break;
			case 1: longi=QVariant((*it).right((*it).length()-2)).toDouble(); 
				if ((*it).left(1) == "W") longi = -longi;	// longi is easting
				ap->setLongitude(longi);
				break;
			case 2:
				ap->setEssid((char *)(*it).mid(2,(*it).length()-4).ascii());
				break;
			case 4:
				ap->setMAC((char *)(*it).mid(2,17).upper().ascii());
				break;
			case 3:
				ap->setMode((*it)=="BSS"?0:1);
				break;
			case 6: {
					QStringList sig = sig.split(" ",(*it),TRUE);
					QStringList::Iterator it2 = sig.begin();
					it2++;
					ap->setSNRMax(QVariant((*it2)).toInt());
					it2++;
					ap->setSignal(QVariant((*it2)).toInt()-149);
					ap->setSignalMax(ap->getSignal());
					it2++;
					ap->setNoise(QVariant((*it2)).toInt()-149);
					break;
				}
			case 8:  // Flags
				{
					if ((*it).toInt(0,16) & 0x10)
						ap->setWEP(TRUE);
					else
						ap->setWEP(FALSE);
					break;
				}
			case 9: // ChannelBits
				{
					ap->setChannel( ((*it).toLong(0,16) & 0x2)? 1 : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x4)? 2 : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x8)? 3 : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x10)? 4 : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x20)? 5 : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x40)? 6 : 0  );
					ap->setChannel( ((*it).toLong(0,16) & 0x80)? 7 : 0  );
					ap->setChannel( ((*it).toLong(0,16) & 0x100)? 8  : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x200)? 9  : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x400)? 10  : 0 );
					ap->setChannel( ((*it).toLong(0,16) & 0x800)? 11 : 0  );
					ap->setChannel( ((*it).toLong(0,16) & 0x1000)? 12 : 0  );
					ap->setChannel( ((*it).toLong(0,16) & 0x2000)? 13 : 0  );
					ap->setChannel( ((*it).toLong(0,16) & 0x4000)? 14 : 0  );
					break;
				}
			}
			k++;
		}
		// Only calculate the vendor on .nsf (summary) files. Although
		//.swl share the same syntax, last are enormous!!!
		if (file->name().right(4).lower() == ".nsf")
			ap->setVendor( (char *)AccessPointListView::getVendor(ap->getMAC(temp)).ascii());

		// Doesn't add the entry if it already exists.
		// Usefull because it's the only difference between .swl and .nsf
		list->addOrUpdateIfExists(ap);
		i++;
	}
}
return 0;
}

int	fileHandler::writeToSWS(QFile * file, APList * list)
{ // Doesn't delete neither file nor list

APEntry * ap;
char temp[255];

if ( file->exists() && KMessageBox::questionYesNo(0, i18n("File %1 exists. Overwrite?").arg(file->name())) == KMessageBox::No )
	return 0;

if (! file->open( IO_WriteOnly ) )
{
	KMessageBox::error(0, i18n("Error while opening '%1' for writing: ").arg(file->name()) + file->errorString());
	return -1;
}

QTextStream stream( file );

QDomDocument doc( QString::null );
QDomProcessingInstruction process = doc.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"utf-8\"");
doc.appendChild(process);
QDomElement root = doc.createElement( "SWSCANNER" );
doc.appendChild( root );

QDomElement tag = doc.createElement( "VERSION" );
root.appendChild( tag );
	QDomText txt = doc.createTextNode( VERSION );
	tag.appendChild( txt );

QDomElement tag2;	// Second level tags
for ( ap = list->first(); ap; ap = list->next() )
{
	tag = doc.createElement( "ROW" );
	root.appendChild( tag );
		tag2 = doc.createElement( "ESSID" );
		tag.appendChild( tag2 );
			txt = doc.createTextNode( QString(ap->getEssid(temp)).simplifyWhiteSpace() );
			tag2.appendChild( txt );
		tag2 = doc.createElement( "MAC" );
		tag.appendChild( tag2 );
			txt = doc.createTextNode( QString(ap->getMAC(temp)).simplifyWhiteSpace() );
			tag2.appendChild( txt );
		tag2 = doc.createElement( "VENDOR" );
		tag.appendChild( tag2 );
			txt = doc.createTextNode( QString(ap->getVendor(temp)).simplifyWhiteSpace() );
			tag2.appendChild( txt );
		tag2 = doc.createElement( "WEP" );
		tag.appendChild( tag2 );
			if ( ap->getWEP() )
				txt = doc.createTextNode( "1" );
			else
				txt = doc.createTextNode( "0" );
			tag2.appendChild( txt );
		tag2 = doc.createElement( "CHANNEL" );
		tag.appendChild( tag2 );
			txt = doc.createTextNode( QString("%1").arg(ap->getChannel()));
			tag2.appendChild( txt );
		tag2 = doc.createElement( "MODE" );
		tag.appendChild( tag2 );
			if ( ap->getMode() == 0)
				txt = doc.createTextNode( "master" );
			else
				txt = doc.createTextNode( "ad-hoc" );
			tag2.appendChild( txt );
		tag2 = doc.createElement( "SIGNAL_MAX" );
		tag.appendChild( tag2 );
			txt = doc.createTextNode( QString("%1").arg(ap->getSignalMax()) );
			tag2.appendChild( txt );
		tag2 = doc.createElement( "SNR_MAX" );
		tag.appendChild( tag2 );
			txt = doc.createTextNode( QString("%1").arg(ap->getSNRMax()) );
			tag2.appendChild( txt );
}
stream << doc.toString();	// Add the generated xml stream to the file
file->close();
return 0;
}

int	fileHandler::writeToNSF(QFile * file, APList * list)
{ // Doesn't delte neither file nor list

APEntry * ap;

gpslog * summaryFile = (gpslog *) file; //NetStumbler log files & summary files have the same syntax

// Error handling:
switch ( summaryFile->open( file->name() ) )
{
	case -1: // Empty filename = cancelled
		KMessageBox::information(0, i18n("Empty filename. Cancelling action."));
		return -2;
	case -2: // User cancelled
		KMessageBox::information(0, i18n("Action cancelled by user."));
		return -2 ;
	case -3: // Error opening file - emits error inside the class
		return -1;
}

for ( ap = list->first(); ap; ap = list->next() )
	summaryFile->addLine(ap, 0, 0);

summaryFile->close();

return 0;
}

int	fileHandler::writeShapeFile(QFile * file, APList * list)
{
	APEntry * ap;
	ShapeHandler * shpDest = new ShapeHandler;
	QFileInfo fi (*file);
	QString shapeName = file->name();
	QString baseName = fi.baseName(); // w/o file extension

	if (file->exists())
		if( KMessageBox::questionYesNo(
					0,
					i18n("A file called %1 already exists. Do you want to overwrite it?").arg( shapeName ),
					"SWScanner") == KMessageBox::No )	
			return -2;	
	
	// only continue if user select 'yes'

	// Delete previous files in order to overwrite
	QStringList shapes = fi.dir().entryList( fi.baseName() + ".[sS][hH][pPxX]; " + fi.baseName() + ".[dD][bB][fF]" );
	for ( QStringList::Iterator it = shapes.begin(); it != shapes.end(); ++it )
	{
		fi.dir().remove(*it);	//delete from dir
	}

	shpDest->createShapefile((char *)QString(baseName).ascii());
	for ( ap = list->first(); ap; ap = list->next() )
	{
		if (ap->getLatitude() == 0 || ap->getLongitude() == 0) 
			continue;	// avoid fake registers storing
		shpDest->newData(ap);
        }
	delete shpDest;
	return 0;
}
