/*
** Copyright (C) 1995, 1996, 1997, 1998 Hewlett-Packard Company
** Originally by Kevin Hughes, kev@kevcom.com, 3/11/94
**
** This program and library is free software; you can redistribute it and/or
** modify it under the terms of the GNU (Library) General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU (Library) General Public License for more details.
**
** You should have received a copy of the GNU (Library) General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**-----------------------------------------------------------
** Added remapVar and initmapentrylist to fix the merge option -M
** G. Hill 3/7/97
**
*/

struct indexentry {
	char *word;
	long fileoffset;
	struct indexentry *nexthash;
	struct resultMerge *result;
};

struct resultMerge{
	int filenum;
	int rank;
	int structure;
	int metaName;
	int frequency;
	int *position;
	struct resultMerge *next;
};

struct indexfileinfo {
	int filenum;
	char *filename;
	char *title;
	int size;
	char *path;
	
	struct docPropertyEntry* docProperties;
	
	struct indexfileinfo *next;
};

struct mapentry {
	int oldnum;
	int newnum;
	struct mapentry *next;
};

struct markentry {
	int num;
	struct markentry *next;
};

struct markentryMerge {
	int num;
	int metaName;
	struct markentryMerge *next;
};	

struct metaMergeEntry {
	char* metaName;
	int oldIndex;
	int newIndex;

	/* is this meta field a Document Property? */
	char isDocProperty;		/* true is doc property */
	char isOnlyDocProperty;	/* true if NOT an indexable meta tag (ie: not in MetaNames) */

	struct metaMergeEntry* next;
};

struct indexfileinfo *indexfilehashlist[BIGHASHSIZE];
struct mapentry *mapentrylist[BIGHASHSIZE];
struct markentry *markentrylist[BIGHASHSIZE];
struct markentryMerge *markentrylistMerge[BIGHASHSIZE];
int remapVar;

/*
** use _AP() for easier cross-compiler (non-ANSI) porting 
** <return value> <functionname> _AP( (<arg prototypes>) );
*/

void readmerge _AP ((char *file1, char *file2, char *outfile));
void addfilenums _AP ((struct indexentry *ip, int num));
struct indexentry *readindexline _AP ((FILE *fp, long limit, struct metaMergeEntry *metaFile));
void addindexfilelist _AP ((int num, char *filename, char *title, int size, struct docPropertyEntry *docProperties, int *totalfiles));
char *extractpath _AP ((char *s));
struct indexfileinfo *lookupindexfilenum _AP ((int num, struct docPropertyEntry** docProperties));
int lookupindexfilepath _AP ((char *path));
struct indexentry *mergeindexentries _AP ((struct indexentry *ip1, struct indexentry *ip2));
struct entryarray * addentryMerge _AP ((struct entryarray *e, struct indexentry *ip));
void remap _AP ((int oldnum, int newnum));
int getmap _AP ((int num));
void marknum _AP ((int num));
void marknumMerge _AP ((int num, int metaName));
int ismarked _AP ((int num));
int ismarkedMerge _AP ((int num, int metaName));
void initmarkentrylist _AP ((void));
void initmarkentrylistMerge _AP ((void));
void initindexfilehashlist _AP ((void));
void freeindexentry _AP ((struct indexentry *ip));
int encodefilenum _AP ((int num));
int decodefilenum _AP ((int num));
void initmapentrylist _AP ((void));
struct resultMerge *addtoresultlistMerge _AP ((struct resultMerge *rp, int filenum, int rank, int structure, int metaName, int frequency, int *position));
struct metaMergeEntry* readMergeMeta _AP ((struct metaMergeEntry* metaFile, FILE* fp));
struct metaMergeEntry* addMetaMerge _AP ((struct metaMergeEntry* metaFile, char* metaWord, int isDocProp, int isOnlyDocProp, int* counter));
struct metaEntry* createMetaMerge _AP ((struct metaMergeEntry* metaFile1, struct metaMergeEntry* metaFile2));
struct metaEntry* addMetaMergeList _AP ((struct metaEntry* metaEntryList, struct metaMergeEntry* metaFileEntry, int* count));
