/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: ListSelectionEvent.java,v $
   Revision 1.1  2004/01/27 09:05:15  bobintetley
   ListModel and List Selection implemented. ScrollPane fix so all components
      scrollable


*/

package swingwtx.swing.event;

import java.util.EventObject;

public class ListSelectionEvent extends EventObject {
    private int firstIndex;
    private int lastIndex;
    private boolean isAdjusting;
    public ListSelectionEvent(Object source, int firstIndex, int lastIndex, boolean isAdjusting) {
	super(source);
	this.firstIndex = firstIndex;
	this.lastIndex = lastIndex;
	this.isAdjusting = isAdjusting;
    }
    public int getFirstIndex() { return firstIndex; }
    public int getLastIndex() { return lastIndex; }
    public boolean getValueIsAdjusting() { return isAdjusting; }

}
