/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JTextField.java,v $
   Revision 1.24  2004/11/02 15:25:05  bobintetley
   Exclude default col size from limiting text entry

   Revision 1.23  2004/11/02 11:26:05  bobintetley
   Fix to default size of JTextArea/JTextField

   Revision 1.22  2004/07/12 19:21:03  dannaab
   Hacked in some support for DocumentFilters

   Revision 1.21  2004/05/06 12:35:22  bobintetley
   Parity with Swing constants for Binary Compatibility + fixes to JDesktopPane

   Revision 1.20  2004/05/05 13:24:32  bobintetley
   Bugfixes and Laurent's patch for binary compatibility on Container.add()

   Revision 1.19  2004/05/04 09:31:43  bobintetley
   PlainDocument/View support and implementation. Build script supports java/javax
   packages - fix to build script to use nested args in bootclasspath (single path broke on my Ant 1.6.1/Linux)

   Revision 1.18  2004/04/30 13:20:43  bobintetley
   Fix to unrealised peer preferred sizes, forwarding window events to
   content panes and fix for mouse drag events.

   Revision 1.17  2004/04/28 11:02:03  bobintetley
   PlainDocument implementation

   Revision 1.16  2004/04/28 08:38:12  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.15  2004/03/18 16:21:37  bobintetley
   JTextComponent/Caret implementation and fix to JFileChooser for bug in GNU classpath

   Revision 1.14  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.13  2003/12/16 15:47:45  bobintetley
   Thread safety added to common methods

   Revision 1.12  2003/12/16 13:14:33  bobintetley
   Use of SwingWTUtils.isSWTControlAvailable instead of null test

   Revision 1.11  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.10  2003/12/15 17:54:36  bobintetley
   Textfield editable support

   Revision 1.9  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwtx.swing.text.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

public class JTextField extends swingwtx.swing.text.JTextComponent implements SwingConstants {
    
    /** The default number of columns used if the app doesn't specify */
    private final static int DEFAULT_COLS = 8;
    
    protected int pCols = DEFAULT_COLS;
    
    /** Used for thread safe property accessors */
    private String retVal = "";
    
    public JTextField() { this(null, "", DEFAULT_COLS); }
    public JTextField(int columns) { this(null, "", columns); }
    public JTextField(String text) { this(null, text, DEFAULT_COLS); }
    public JTextField(String text, int columns) { this(null, text, columns); }
    public JTextField(Document doc, String text, int columns) {
        super();
        if (doc != null) setDocument(doc);
        pText = text; 
        pCols = columns; 
        if (pCols != 0) calculateFromCols();
        if (pText != null)
            if (!pText.equals(""))
                view.updateModelFromComponent(pText);
    }
    
    /**
     * Calculates the component's preferred size based on how
     * many columns the user chose.
     */
    protected void calculateFromCols() {
        setPreferredSize( new swingwt.awt.Dimension((SwingWTUtils.getRenderStringWidth("W") * pCols), 25));
    }
    
    public int getColumns() { return pCols; }
    public void setColumns(int columns) { pCols = columns; if (SwingWTUtils.isSWTControlAvailable(ppeer)) ppeer.setTextLimit(pCols); }
    public void setEditable(boolean b) { pEditable = b; if (SwingWTUtils.isSWTControlAvailable(ppeer)) ppeer.setEditable(b); }
    public boolean isEditable() { return pEditable; }
    
    /** Overriden to calculate non-realised
     *  preferred size.
     */
    protected swingwt.awt.Dimension calculatePreferredSize() {
    	swingwt.awt.Dimension size = new 
			swingwt.awt.Dimension((SwingWTUtils.getRenderStringWidth("W") * pCols), 25);
    	setSize(size);
    	return size;
    }
    
    /**
     * Once a parent component receives an "add" call for a child, this being
     * the child, this should be called to tell us to instantiate the peer
     * and load in any cached properties.
     */
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
        ppeer = new Text(parent.getComposite(), SWT.BORDER | SWT.SINGLE);
        if (pText == null)
            ppeer.setText("");
        else
            ppeer.setText(pText);
        ppeer.setEditable(pEditable);
        if (pCols > 1 && pCols != DEFAULT_COLS) ppeer.setTextLimit(pCols);
        peer = ppeer;
        this.parent = parent;
        ppeer.addVerifyListener(new TextEventHandler());
    }
}
