/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: JButtonMappedAction.java,v $
   Revision 1.1  2004/03/31 08:16:40  bobintetley
   Code clean up and separating out of JButtonMappedAction class

 
 */

package swingwtx.swing;

import swingwt.awt.event.*;

/**
 * Utility class - maps a JButton and Action together.
 *
 * Used by JToolBar/JButton when linking toolbar items
 * together.
 *
 * @author Robin Rawson-Tetley
 */
class JButtonMappedAction extends AbstractAction {
    
    JButton button = null;
    
    public JButtonMappedAction(JButton b) {
        button = b;    
    }
    public void actionPerformed(ActionEvent e) {
        button.processActionEvent(0);
    }
    public JButton getJButton() { return button; }
    
}