/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: SWTGraphics2DRenderer.java,v $
   Revision 1.11  2004/06/11 03:29:26  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.10  2004/05/05 13:24:30  bobintetley
   Bugfixes and Laurent's patch for binary compatibility on Container.add()

   Revision 1.9  2004/04/30 23:18:24  dannaab
   List selection support, misc bug fixes

   Revision 1.8  2004/04/20 14:14:19  bobintetley
   Fix to drawImage() in SWTGraphics2DRenderer to scale images correctly

   Revision 1.7  2004/03/30 10:42:44  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.6  2004/03/21 17:22:53  bobintetley
   Compatibility methods for awt Graphics, List and Label. Dummy Applet implementation

   Revision 1.5  2004/02/26 13:53:56  bobintetley
   SWT GC can be grabbed externally now

   Revision 1.4  2004/01/26 10:37:09  bobintetley
   Better painting support

   Revision 1.3  2004/01/26 09:09:54  bobintetley
   JComboBox event fixes, fix to Java2D garbage collection and ComboBox demo

   Revision 1.2  2004/01/15 15:58:41  bobintetley
   Extra thread safety

   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work


*/

package swingwt.awt;

import org.eclipse.swt.graphics.GC;
import swingwt.awt.font.FontRenderContext;
import swingwt.awt.font.GlyphVector;
import swingwt.awt.geom.AffineTransform;
import swingwt.awt.image.*;

import java.util.Map;

/**
 * This class is the final point for the mapped AWT graphics stuff - it
 * provides the rendering capabilities to the Graphics/Graphics2D classes
 * via mappings to SWT GC calls.
 *
 * @author  Robin Rawson-Tetley
 */
public class SWTGraphics2DRenderer extends Graphics2D {
    
    /** The SWT graphics context for painting */
    protected GC gc = null;
    /** The current font for the GC */
    protected swingwt.awt.Font f = null;
    /** The current colour for the GC */
    protected swingwt.awt.Color c = null;
    /** Whether this object should use a finalizer based destructor. This is
     *  set to false generally by Paint Events, as they will ultimately handle
     *  the GC's destruction.
     */
    protected boolean shouldDestroy = false;
    
    public SWTGraphics2DRenderer(final GC gcon) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc = gcon;
                
                // Note - we don't to clean these up, since the GC owns and
                // created them.
                f = new swingwt.awt.Font(gc.getFont());
                c = new swingwt.awt.Color(gc.getForeground());
            }
        });
    }
    
    /**
     * @param needToCleanUp Set to true if you want a finalize destructor
     */
    public SWTGraphics2DRenderer(GC gc, boolean needToCleanUp) {
        this(gc);
        shouldDestroy = needToCleanUp;
    }
    
    public Graphics create() { 
        //return new SWTGraphics2DRenderer(gc.clone(), true);
        return this;
    }

    public void dispose() {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.dispose();
            }
        });
    }
    
    /** Returns the SWT GC used for direct manipulation */
    public GC getSWTGC() { return gc; }
    
    public void clearRect(final int x, final int y, final int width, final int height) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.fillRectangle(x, y, width, height);    
            }
        });
    }
    /** NOT IMPLEMENTED */
    public void clipRect(int x, int y, int width, int height) {  }
          
    public void copyArea(final int x, final int y, final int width, final int height, final  int dx, final int dy) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.copyArea(x, y, width, height, dx, dy);    
            }
        });
    }

    public void redrawUnder(final int x, final int y, final int width, final int height) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image(
                        swingwtx.swing.SwingWTUtils.getDisplay(), width, height);
                gc.copyArea(image, x, y);
                gc.drawImage(image, x, y);
            }
        });
    }

    public void drawArc(final int x, final int y, final int width, final int height, final  int startAngle,final  int arcAngle) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawArc(x, y, width, height, startAngle, arcAngle);    
            }
        });
    }
    
    public void drawBytes(final byte[] data, final int offset, final int length, final int x, final int y) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawString(new String(data), x, y, true);
            }
        });
    }
    public void drawChars(final char[] data, final int offset, final int length, final int x, final int y) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawString(new String(data), x, y, true);
            }
        });
    }
    
    public boolean drawImage(final swingwt.awt.Image img, final int x, final int y, final Color bgcolor, final ImageObserver observer) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawImage(img.image, x, y);
            }
        });
        return true;
    }     
    public boolean drawImage(final swingwt.awt.Image img, final int x, final int y, final ImageObserver observer) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawImage(img.image, x, y);    
            }
        });
        return true;
    }
    public boolean drawImage(final swingwt.awt.Image img, final int x, final int y, final int width, final int height, final Color bgcolor, final ImageObserver observer) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawImage(img.image, x, y);    
            }
        });
        return true;
    }
    public boolean drawImage(final swingwt.awt.Image img, final int x, final int y, final int width, final int height, final ImageObserver observer) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawImage(img.image, 0, 0, img.getWidth(null), img.getHeight(null), x, y, width, height);    
            }
        });
        return true;
    }
    public boolean drawImage(final swingwt.awt.Image img, final int dx1, final int dy1, final int dx2, final int dy2, final int sx1, final int sy1, final int sx2, final int sy2, final Color bgcolor,final  ImageObserver observer) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawImage(img.image, sx1, sy1, sx2 - sx1, sy2 - sy1, dx1, dy1, dx2 - dx1, dy2 - dy1);
            }
        });
        return true;
    }
    public boolean drawImage(final swingwt.awt.Image img, final int dx1, final int dy1, final int dx2, final int dy2, final int sx1, final int sy1, final int sx2, final int sy2, ImageObserver observer) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawImage(img.image, sx1, sy1, sx2 - sx1, sy2 - sy1, dx1, dy1, dx2 - dx1, dy2 - dy1);
            }
        });
        return true;
    }

    public void drawLine(final int x1, final int y1, final int x2, final int y2) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawLine(x1, y1, x2, y2);    
            }
        });
    }
          
    public void drawOval(final int x, final int y, final int width, final int height) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawOval(x, y, width, height);
            }
        });
    }
        
    /** NOT IMPLEMENTED */
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            
    }

    /** NOT IMPLEMENTED */
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        
    }
    
    public void drawString(final String str, final int x, final int y) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawString(str, x, y, false);
            }
        });
    }
    
    public void drawString(final String str, final int x, final int y, final boolean transparent) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.drawString(str, x, y, transparent);
            }
        });
    }
    
    public void fillArc(final int x, final int y, final int width, final int height, final int startAngle, final int arcAngle) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.setBackground(c.getSWTColor());
                gc.fillArc(x, y, width, height, startAngle, arcAngle);    
            }
        });
    }
          
    public void fillOval(final int x, final int y, final int width, final int height) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.setBackground(c.getSWTColor());
                gc.fillOval(x, y, width, height);
            }
        });     
    }
    
    /** NOT IMPLEMENTED */
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
    }
          
    public void fillRect(final int x, final int y, final int width, final int height) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.setBackground(c.getSWTColor());
                gc.fillRectangle(x, y, width, height);    
            }
        });
    }
    
    /** Calls <code>fillRect</code> instead */
    public void fillRoundRect(final int x, final int y, final int width, final int height, final int arcWidth, final int arcHeight) {
        fillRect(x, y, width, height);
    }
    
    public Font getFont() {
        return f;
    }
    
    public Color getColor() {
        return c;
    }
    
    public void setFont(swingwt.awt.Font f) {
        if (f != this.f) {
            this.f = f;
            swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
                public void run() {
                    gc.setFont(SWTGraphics2DRenderer.this.f.getSWTFont());
                }
            });
        }
    }
    
    public void setColor(swingwt.awt.Color color) {
        this.c = color;
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.setForeground(c.getSWTColor());
            }
        });
    }
    
    protected void finalize() throws Throwable {
        if (shouldDestroy) {
            swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
                public void run() {
                    gc.dispose();
                }
            });
        }
    }
    
    /** NOT IMPLEMENTED */
    public void addRenderingHints(Map hints) {
    }
    
    /** NOT IMPLEMENTED */
    public void clip(Shape s) {
    }
    
    /** NOT IMPLEMENTED */
    public void draw(Shape s) {
    }
    
    /** NOT IMPLEMENTED */
    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }
    
    /** NOT IMPLEMENTED */
    public void fill(Shape s) {
    }
    
    public Color getBackground() {
        return new swingwt.awt.Color(gc.getBackground());
    }
    
    /** NOT IMPLEMENTED */
    public Composite getComposite() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public FontRenderContext getFontRenderContext() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public Paint getPaint() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public Object getRenderingHint(Object hintKey) {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public RenderingHints getRenderingHints() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public Stroke getStroke() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public AffineTransform getTransform() {
        return null;
    }
    
    /** NOT IMPLEMENTED */
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }
    
    /** NOT IMPLEMENTED */
    public void rotate(double theta) {
    }
    
    /** NOT IMPLEMENTED */
    public void rotate(double theta, double x, double y) {
    }
    
    /** NOT IMPLEMENTED */
    public void scale(double sx, double sy) {
    }
    
    public void setBackground(final swingwt.awt.Color color) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.setBackground(color.getSWTColor());
            }
        });
    }
    
    /** NOT IMPLEMENTED */
    public void setComposite(Composite comp) {
    }
    
    /** NOT IMPLEMENTED */
    public void setPaint(Paint paint) {
    }
    
    /** NOT IMPLEMENTED */
    public void setRenderingHint(Object hintKey, Object hintValue) {
    }
    
    /** NOT IMPLEMENTED */
    public void setRenderingHints(Map hints) {
    }
    
    /** NOT IMPLEMENTED */
    public void setStroke(Stroke s) {
    }
    
    /** NOT IMPLEMENTED */
    public void setTransform(AffineTransform Tx) {
    }
    
    /** NOT IMPLEMENTED */
    public void shear(double shx, double shy) {
    }
    
    /** NOT IMPLEMENTED */
    public void transform(AffineTransform Tx) {
    }
    
    /** NOT IMPLEMENTED */
    public void translate(double tx, double ty) {
    }
    
    /** NOT IMPLEMENTED */
    public void translate(int x, int y) {
    }
    
    /** NOT IMPLEMENTED */
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }
    
    /** NOT IMPLEMENTED */
    public Shape getClip() {
        return null;
    }
    
    public Rectangle getClipBounds() {
        final swingwt.awt.Rectangle r = new swingwt.awt.Rectangle();
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                org.eclipse.swt.graphics.Rectangle rc = gc.getClipping();
                r.height = rc.height;
                r.width = rc.width;
                r.x = rc.x;
                r.y = rc.y;
            }
        });
        return r;
    }
    
    public FontMetrics getFontMetrics(Font f) {
        return new swingwt.awt.FontMetrics(f);
    }
    
    /** NOT IMPLEMENTED */
    public void setClip(Shape clip) {
    }
    
    public void setClip(final int x, final int y, final int width, final int height) {
        swingwtx.swing.SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                gc.setClipping(x, y, width, height);
            }
        });
    }
    
    /** NOT IMPLEMENTED */
    public void setPaintMode() {
    }
    
    /** NOT IMPLEMENTED */
    public void setXORMode(Color c1) {
    }
    
}
