/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Control;

public final class FormData {
    public int height;
    public int width;
    public FormAttachment left;
    public FormAttachment right;
    public FormAttachment top;
    public FormAttachment bottom;
    int cacheHeight;
    int cacheWidth;
    FormAttachment cacheLeft;
    FormAttachment cacheRight;
    FormAttachment cacheTop;
    FormAttachment cacheBottom;
    boolean isVisited;

    public FormData() {
        this(-1, -1);
    }

    public FormData(int width, int height) {
        this.width = width;
        this.height = height;
    }

    FormAttachment getBottomAttachment(int spacing) {
        if (this.cacheBottom != null) {
            return this.cacheBottom;
        }
        if (this.isVisited) {
            this.cacheBottom = new FormAttachment(0, this.cacheHeight);
            return this.cacheBottom;
        }
        if (this.bottom == null) {
            if (this.top == null) {
                this.cacheBottom = new FormAttachment(0, this.cacheHeight);
                return this.cacheBottom;
            }
            this.cacheBottom = this.getTopAttachment(spacing).plus(this.cacheHeight);
            return this.cacheBottom;
        }
        Control control = this.bottom.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.bottom.control = null;
        }
        if (control == null) {
            this.cacheBottom = this.bottom;
            return this.cacheBottom;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment bottomAttachment = formData.getBottomAttachment(spacing);
        switch (this.bottom.alignment) {
            case 1024: {
                this.cacheBottom = bottomAttachment.plus(this.bottom.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment topAttachment = formData.getTopAttachment(spacing);
                FormAttachment bottomHeight = bottomAttachment.minus(topAttachment);
                this.cacheBottom = bottomAttachment.minus(bottomHeight.minus(this.cacheHeight).divide(2));
                break;
            }
            default: {
                FormAttachment topAttachment = formData.getTopAttachment(spacing);
                this.cacheBottom = topAttachment.plus(this.bottom.offset - spacing);
            }
        }
        this.isVisited = false;
        return this.cacheBottom;
    }

    FormAttachment getLeftAttachment(int spacing) {
        if (this.cacheLeft != null) {
            return this.cacheLeft;
        }
        if (this.isVisited) {
            this.cacheLeft = new FormAttachment(0, 0);
            return this.cacheLeft;
        }
        if (this.left == null) {
            if (this.right == null) {
                this.cacheLeft = new FormAttachment(0, 0);
                return this.cacheLeft;
            }
            this.cacheLeft = this.getRightAttachment(spacing).minus(this.cacheWidth);
            return this.cacheLeft;
        }
        Control control = this.left.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.left.control = null;
        }
        if (control == null) {
            this.cacheLeft = this.left;
            return this.cacheLeft;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment leftAttachment = formData.getLeftAttachment(spacing);
        switch (this.left.alignment) {
            case 16384: {
                this.cacheLeft = leftAttachment.plus(this.left.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment rightAttachment = formData.getRightAttachment(spacing);
                FormAttachment leftWidth = rightAttachment.minus(leftAttachment);
                this.cacheLeft = leftAttachment.plus(leftWidth.minus(this.cacheWidth).divide(2));
                break;
            }
            default: {
                FormAttachment rightAttachment = formData.getRightAttachment(spacing);
                this.cacheLeft = rightAttachment.plus(this.left.offset + spacing);
            }
        }
        this.isVisited = false;
        return this.cacheLeft;
    }

    FormAttachment getRightAttachment(int spacing) {
        if (this.cacheRight != null) {
            return this.cacheRight;
        }
        if (this.isVisited) {
            this.cacheRight = new FormAttachment(0, this.cacheWidth);
            return this.cacheRight;
        }
        if (this.right == null) {
            if (this.left == null) {
                this.cacheRight = new FormAttachment(0, this.cacheWidth);
                return this.cacheRight;
            }
            this.cacheRight = this.getLeftAttachment(spacing).plus(this.cacheWidth);
            return this.cacheRight;
        }
        Control control = this.right.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.right.control = null;
        }
        if (control == null) {
            this.cacheRight = this.right;
            return this.cacheRight;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment rightAttachment = formData.getRightAttachment(spacing);
        switch (this.right.alignment) {
            case 131072: {
                this.cacheRight = rightAttachment.plus(this.right.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment leftAttachment = formData.getLeftAttachment(spacing);
                FormAttachment rightWidth = rightAttachment.minus(leftAttachment);
                this.cacheRight = rightAttachment.minus(rightWidth.minus(this.cacheWidth).divide(2));
                break;
            }
            default: {
                FormAttachment leftAttachment = formData.getLeftAttachment(spacing);
                this.cacheRight = leftAttachment.plus(this.right.offset - spacing);
            }
        }
        this.isVisited = false;
        return this.cacheRight;
    }

    FormAttachment getTopAttachment(int spacing) {
        if (this.cacheTop != null) {
            return this.cacheTop;
        }
        if (this.isVisited) {
            this.cacheTop = new FormAttachment(0, 0);
            return this.cacheTop;
        }
        if (this.top == null) {
            if (this.bottom == null) {
                this.cacheTop = new FormAttachment(0, 0);
                return this.cacheTop;
            }
            this.cacheTop = this.getBottomAttachment(spacing).minus(this.cacheHeight);
            return this.cacheTop;
        }
        Control control = this.top.control;
        if (control != null && control.isDisposed()) {
            control = null;
            this.top.control = null;
        }
        if (control == null) {
            this.cacheTop = this.top;
            return this.cacheTop;
        }
        this.isVisited = true;
        FormData formData = (FormData)control.getLayoutData();
        FormAttachment topAttachment = formData.getTopAttachment(spacing);
        switch (this.top.alignment) {
            case 128: {
                this.cacheTop = topAttachment.plus(this.top.offset);
                break;
            }
            case 0x1000000: {
                FormAttachment bottomAttachment = formData.getBottomAttachment(spacing);
                FormAttachment topHeight = bottomAttachment.minus(topAttachment);
                this.cacheTop = topAttachment.plus(topHeight.minus(this.cacheHeight).divide(2));
                break;
            }
            default: {
                FormAttachment bottomAttachment = formData.getBottomAttachment(spacing);
                this.cacheTop = bottomAttachment.plus(this.top.offset + spacing);
            }
        }
        this.isVisited = false;
        return this.cacheTop;
    }
}

