/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class Browser
extends Composite {
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";
    static final int MAX_PROGRESS = 100;
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    static int Delegate;
    static Hashtable Map;
    static Callback callback;
    int webViewHandle;
    int identifier;
    int resourceCount;
    String url = "";
    org.eclipse.swt.graphics.Point location;
    org.eclipse.swt.graphics.Point size;

    static {
        Map = new Hashtable();
    }

    public Browser(Composite parent, int style) {
        super(parent, style);
        int[] response = new int[1];
        int err = OS.Gestalt((int)1937339254, (int[])response);
        if (err != 0 || (response[0] & 0xFFFF) < 4144) {
            this.dispose();
            SWT.error(2);
        }
        int[] outControl = new int[1];
        try {
            WebKit.HIWebViewCreate(outControl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.dispose();
            SWT.error(2);
        }
        this.webViewHandle = outControl[0];
        if (this.webViewHandle == 0) {
            this.dispose();
            SWT.error(2);
        }
        OS.HIViewAddSubview((int)this.handle, (int)this.webViewHandle);
        OS.HIViewSetVisible((int)this.webViewHandle, (boolean)true);
        final int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        final int notificationCenter = WebKit.objc_msgSend(WebKit.C_NSNotificationCenter, WebKit.S_defaultCenter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        Map.remove(new Integer(webView));
                        WebKit.objc_msgSend(notificationCenter, WebKit.S_removeObserver_name_object, Delegate, 0, webView);
                        break;
                    }
                    case 23: {
                        CGRect bounds = new CGRect();
                        OS.HIViewSetFrame((int)Browser.this.webViewHandle, (CGRect)bounds);
                        break;
                    }
                    case 22: {
                        CGRect bounds = new CGRect();
                        OS.HIViewGetFrame((int)Browser.this.handle, (CGRect)bounds);
                        OS.HIViewSetFrame((int)Browser.this.webViewHandle, (CGRect)bounds);
                        break;
                    }
                    case 11: {
                        if (!Browser.this.isVisible()) break;
                        CGRect bounds = new CGRect();
                        OS.HIViewGetFrame((int)Browser.this.handle, (CGRect)bounds);
                        if (bounds.width < 0.0f) {
                            bounds.width = 0.0f;
                        }
                        if (bounds.height < 0.0f) {
                            bounds.height = 0.0f;
                        }
                        bounds.width += 1.0f;
                        OS.HIViewSetFrame((int)Browser.this.webViewHandle, (CGRect)bounds);
                        bounds.width -= 1.0f;
                        OS.HIViewSetFrame((int)Browser.this.webViewHandle, (CGRect)bounds);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(11, listener);
        Shell shell = this.getShell();
        shell.addListener(11, listener);
        shell.addListener(22, listener);
        shell.addListener(23, listener);
        Composite c = this;
        do {
            c.addListener(22, listener);
            c.addListener(23, listener);
        } while ((c = c.getParent()) != shell);
        if (callback == null) {
            callback = new Callback(this.getClass(), "eventProc", 6);
            int eventProc = callback.getAddress();
            Delegate = WebKit.objc_msgSend(WebKit.C_WebKitDelegate, WebKit.S_alloc);
            Delegate = WebKit.objc_msgSend(Delegate, WebKit.S_initWithProc, eventProc);
        }
        Map.put(new Integer(webView), this);
        WebKit.objc_msgSend(webView, WebKit.S_setFrameLoadDelegate, Delegate);
        WebKit.objc_msgSend(webView, WebKit.S_setResourceLoadDelegate, Delegate);
        WebKit.objc_msgSend(webView, WebKit.S_setUIDelegate, Delegate);
        WebKit.objc_msgSend(notificationCenter, WebKit.S_addObserver_selector_name_object, Delegate, WebKit.S_handleNotification, 0, webView);
    }

    static int eventProc(int webview, int selector, int arg0, int arg1, int arg2, int arg3) {
        Object o = Map.get(new Integer(webview));
        if (o instanceof Browser) {
            return ((Browser)o).handleCallback(selector, arg0, arg1, arg2, arg3);
        }
        return 0;
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = newCloseWindowListeners;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = listener;
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, this.titleListeners.length);
        this.titleListeners = newTitleListeners;
        this.titleListeners[this.titleListeners.length - 1] = listener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = listener;
    }

    public boolean back() {
        this.checkWidget();
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        return WebKit.objc_msgSend(webView, WebKit.S_goBack) != 0;
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    public boolean forward() {
        this.checkWidget();
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        return WebKit.objc_msgSend(webView, WebKit.S_goForward) != 0;
    }

    public String getUrl() {
        this.checkWidget();
        return this.url;
    }

    int handleCallback(int selector, int arg0, int arg1, int arg2, int arg3) {
        int ret = 0;
        switch (selector) {
            case 1: {
                this.didFailProvisionalLoadWithError(arg0, arg1);
                break;
            }
            case 2: {
                this.didFinishLoadForFrame(arg0);
                break;
            }
            case 3: {
                this.didReceiveTitle(arg0, arg1);
                break;
            }
            case 4: {
                this.didStartProvisionalLoadForFrame(arg0);
                break;
            }
            case 5: {
                this.didFinishLoadingFromDataSource(arg0, arg1);
                break;
            }
            case 6: {
                this.didFailLoadingWithError(arg0, arg1, arg2);
                break;
            }
            case 7: {
                ret = this.identifierForInitialRequest(arg0, arg1);
                break;
            }
            case 8: {
                ret = this.willSendRequest(arg0, arg1, arg2, arg3);
                break;
            }
            case 9: {
                this.handleNotification(arg0);
                break;
            }
            case 10: {
                this.didCommitLoadForFrame(arg0);
                break;
            }
            case 11: {
                ret = this.createWebViewWithRequest(arg0);
                break;
            }
            case 12: {
                this.webViewShow(arg0);
                break;
            }
            case 13: {
                this.setFrame(arg0);
                break;
            }
            case 14: {
                this.webViewClose();
                break;
            }
            case 15: {
                ret = this.contextMenuItemsForElement(arg0, arg1);
            }
        }
        return ret;
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        return WebKit.objc_msgSend(webView, WebKit.S_canGoBack) != 0;
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        return WebKit.objc_msgSend(webView, WebKit.S_canGoForward) != 0;
    }

    public void refresh() {
        this.checkWidget();
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        WebKit.objc_msgSend(webView, WebKit.S_reload, 0);
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            if (listener == this.closeWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, index);
        System.arraycopy(this.closeWindowListeners, index + 1, newCloseWindowListeners, index, this.closeWindowListeners.length - index - 1);
        this.closeWindowListeners = newCloseWindowListeners;
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.locationListeners.length) {
            if (listener == this.locationListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.progressListeners.length) {
            if (listener == this.progressListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            if (listener == this.statusTextListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.titleListeners.length) {
            if (listener == this.titleListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, index);
        System.arraycopy(this.titleListeners, index + 1, newTitleListeners, index, this.titleListeners.length - index - 1);
        this.titleListeners = newTitleListeners;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            if (listener == this.visibilityWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
        System.arraycopy(this.visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, this.visibilityWindowListeners.length - index - 1);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        int length = html.length();
        char[] buffer = new char[length];
        html.getChars(0, length, buffer, 0);
        int string = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
        String baseURL = "about:blank";
        length = baseURL.length();
        buffer = new char[length];
        baseURL.getChars(0, length, buffer, 0);
        int URLString = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
        int URL2 = WebKit.objc_msgSend(WebKit.C_NSURL, WebKit.S_URLWithString, URLString);
        OS.CFRelease((int)URLString);
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        int mainFrame = WebKit.objc_msgSend(webView, WebKit.S_mainFrame);
        WebKit.objc_msgSend(mainFrame, WebKit.S_loadHTMLStringbaseURL, string, URL2);
        OS.CFRelease((int)string);
        return true;
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < url.length()) {
            char c = url.charAt(i);
            if (c == ' ') {
                buffer.append("%20");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        int length = buffer.length();
        char[] chars = new char[length];
        buffer.getChars(0, length, chars, 0);
        int sHandle = OS.CFStringCreateWithCharacters((int)0, (char[])chars, (int)length);
        int inURL = WebKit.objc_msgSend(WebKit.C_NSURL, WebKit.S_URLWithString, sHandle);
        OS.CFRelease((int)sHandle);
        int request = WebKit.objc_msgSend(WebKit.C_NSURLRequest, WebKit.S_requestWithURL, inURL);
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        int mainFrame = WebKit.objc_msgSend(webView, WebKit.S_mainFrame);
        WebKit.objc_msgSend(mainFrame, WebKit.S_loadRequest, request);
        return true;
    }

    public void stop() {
        this.checkWidget();
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        WebKit.objc_msgSend(webView, WebKit.S_stopLoading, 0);
    }

    void didFailProvisionalLoadWithError(int error, int frame) {
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        if (frame == WebKit.objc_msgSend(webView, WebKit.S_mainFrame)) {
            this.identifier = 0;
        }
    }

    void didFinishLoadForFrame(int frame) {
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        if (frame == WebKit.objc_msgSend(webView, WebKit.S_mainFrame)) {
            final Display display = this.getDisplay();
            final ProgressEvent progress = new ProgressEvent(this);
            progress.display = this.getDisplay();
            progress.widget = this;
            progress.current = 100;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                final ProgressListener listener = this.progressListeners[i];
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && !Browser.this.isDisposed()) {
                            listener.completed(progress);
                        }
                    }
                });
                ++i;
            }
            this.identifier = 0;
        }
    }

    void didReceiveTitle(int title, int frame) {
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        if (frame == WebKit.objc_msgSend(webView, WebKit.S_mainFrame)) {
            int length = OS.CFStringGetLength((int)title);
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters((int)title, (CFRange)range, (char[])buffer);
            String newTitle = new String(buffer);
            TitleEvent newEvent = new TitleEvent(this);
            newEvent.display = this.getDisplay();
            newEvent.widget = this;
            newEvent.title = newTitle;
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(newEvent);
                ++i;
            }
        }
    }

    void didStartProvisionalLoadForFrame(int frame) {
    }

    void didCommitLoadForFrame(int frame) {
        boolean top;
        int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
        int dataSource = WebKit.objc_msgSend(frame, WebKit.S_dataSource);
        int request = WebKit.objc_msgSend(dataSource, WebKit.S_request);
        int url = WebKit.objc_msgSend(request, WebKit.S_URL);
        int s = WebKit.objc_msgSend(url, WebKit.S_absoluteString);
        int length = OS.CFStringGetLength((int)s);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters((int)s, (CFRange)range, (char[])buffer);
        String url2 = new String(buffer);
        final Display display = this.getDisplay();
        boolean bl = top = frame == WebKit.objc_msgSend(webView, WebKit.S_mainFrame);
        if (top) {
            this.resourceCount = 0;
            this.url = url2;
            final ProgressEvent progress = new ProgressEvent(this);
            progress.display = display;
            progress.widget = this;
            progress.current = 1;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                final ProgressListener listener = this.progressListeners[i];
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!display.isDisposed() && !Browser.this.isDisposed()) {
                            listener.changed(progress);
                        }
                    }
                });
                ++i;
            }
            StatusTextEvent statusText = new StatusTextEvent(this);
            statusText.display = display;
            statusText.widget = this;
            statusText.text = url2;
            int i2 = 0;
            while (i2 < this.statusTextListeners.length) {
                this.statusTextListeners[i2].changed(statusText);
                ++i2;
            }
        }
        LocationEvent location = new LocationEvent(this);
        location.display = display;
        location.widget = this;
        location.location = url2;
        location.top = top;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(location);
            ++i;
        }
    }

    void didFinishLoadingFromDataSource(int identifier, int dataSource) {
    }

    void didFailLoadingWithError(int identifier, int error, int dataSource) {
    }

    int identifierForInitialRequest(int request, int dataSource) {
        final Display display = this.getDisplay();
        final ProgressEvent progress = new ProgressEvent(this);
        progress.display = display;
        progress.widget = this;
        progress.current = this.resourceCount;
        progress.total = Math.max(this.resourceCount, 100);
        int i = 0;
        while (i < this.progressListeners.length) {
            final ProgressListener listener = this.progressListeners[i];
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed() && !Browser.this.isDisposed()) {
                        listener.changed(progress);
                    }
                }
            });
            ++i;
        }
        int identifier = WebKit.objc_msgSend(WebKit.C_NSNumber, WebKit.S_numberWithInt, this.resourceCount++);
        if (this.identifier == 0) {
            int webView = WebKit.HIWebViewGetWebView(this.webViewHandle);
            int frame = WebKit.objc_msgSend(dataSource, WebKit.S_webFrame);
            if (frame == WebKit.objc_msgSend(webView, WebKit.S_mainFrame)) {
                this.identifier = identifier;
            }
        }
        return identifier;
    }

    int willSendRequest(int identifier, int request, int redirectResponse, int dataSource) {
        int url = WebKit.objc_msgSend(request, WebKit.S_URL);
        int s = WebKit.objc_msgSend(url, WebKit.S_absoluteString);
        int length = OS.CFStringGetLength((int)s);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters((int)s, (CFRange)range, (char[])buffer);
        String url2 = new String(buffer);
        LocationEvent newEvent = new LocationEvent(this);
        newEvent.display = this.getDisplay();
        newEvent.widget = this;
        newEvent.location = url2;
        newEvent.doit = true;
        if (this.locationListeners != null) {
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(newEvent);
                ++i;
            }
        }
        return newEvent.doit ? request : 0;
    }

    void handleNotification(int notification) {
    }

    int createWebViewWithRequest(int request) {
        WindowEvent newEvent = new WindowEvent(this);
        newEvent.display = this.getDisplay();
        newEvent.widget = this;
        if (this.openWindowListeners != null) {
            int i = 0;
            while (i < this.openWindowListeners.length) {
                this.openWindowListeners[i].open(newEvent);
                ++i;
            }
        }
        int webView = 0;
        Browser browser = newEvent.browser;
        if (browser != null && !browser.isDisposed()) {
            webView = WebKit.HIWebViewGetWebView(browser.webViewHandle);
            int mainFrame = WebKit.objc_msgSend(webView, WebKit.S_mainFrame);
            WebKit.objc_msgSend(mainFrame, WebKit.S_loadRequest, request);
        }
        return webView;
    }

    void webViewShow(int sender) {
        Shell parent = this.getShell();
        org.eclipse.swt.graphics.Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
        WindowEvent newEvent = new WindowEvent(this);
        newEvent.display = this.getDisplay();
        newEvent.widget = this;
        if (this.location != null) {
            newEvent.location = this.location;
        }
        if (this.size != null) {
            newEvent.size = this.size;
        }
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[i].show(newEvent);
            ++i;
        }
        this.location = null;
        this.size = null;
    }

    void setFrame(int frame) {
        float[] dest = new float[4];
        OS.memcpy((float[])dest, (int)frame, (int)16);
        Rectangle bounds = this.getDisplay().getBounds();
        this.location = new org.eclipse.swt.graphics.Point((int)dest[0], bounds.height - (int)dest[1] - (int)dest[3]);
        this.size = new org.eclipse.swt.graphics.Point((int)dest[2], (int)dest[3]);
    }

    void webViewClose() {
        Shell parent = this.getShell();
        WindowEvent newEvent = new WindowEvent(this);
        newEvent.display = this.getDisplay();
        newEvent.widget = this;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.dispose();
        if (parent.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
    }

    int contextMenuItemsForElement(int element, int defaultMenuItems) {
        Point pt = new Point();
        OS.GetGlobalMouse((Point)pt);
        Event event = new Event();
        event.x = pt.h;
        event.y = pt.v;
        this.notifyListeners(35, event);
        Menu menu = this.getMenu();
        if (!event.doit) {
            return 0;
        }
        if (menu != null && !menu.isDisposed()) {
            if (event.x != pt.h || event.y != pt.v) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return defaultMenuItems;
    }
}

