/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.text;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.text.AbstractDocument;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Caret;
import swingwtx.swing.text.DefaultCaret;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.DocumentFilter;
import swingwtx.swing.text.PlainDocument;
import swingwtx.swing.text.PlainView;

public class JTextComponent
extends JComponent {
    protected Text ppeer = null;
    protected String pText = "";
    protected boolean pEditable = true;
    protected boolean pWordWrap = false;
    protected int pRows = 0;
    protected int pCols = 0;
    protected int selStart = -1;
    protected int selEnd = -1;
    protected Caret caret = new DefaultCaret(this);
    protected Document doc = new PlainDocument();
    protected PlainView view = new PlainView(this.doc, this);
    protected String retVal = "";
    protected int iRetVal = 0;

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.view.setDocument(doc);
    }

    public String getText() {
        this.retVal = "";
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JTextComponent.this.retVal = SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer) ? JTextComponent.this.ppeer.getText() : JTextComponent.this.pText;
            }
        });
        return this.retVal;
    }

    public void setText(String text) {
        this.pText = text == null ? "" : text;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.setText(JTextComponent.this.pText);
                }
                if (JTextComponent.this.getDocument() instanceof AbstractDocument) {
                    try {
                        ((AbstractDocument)JTextComponent.this.getDocument()).getFilterBypass().replace(0, JTextComponent.this.getDocument().getLength(), JTextComponent.this.pText, null);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void setEditable(boolean b) {
        this.pEditable = b;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.ppeer.setEditable(b);
        }
    }

    public boolean isEditable() {
        return this.pEditable;
    }

    public int getCaretPosition() {
        this.iRetVal = 0;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JTextComponent.this.iRetVal = !SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer) ? -1 : JTextComponent.this.ppeer.getCaretPosition();
            }
        });
        return this.iRetVal;
    }

    public void setCaretPosition(final int pos) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.setSelection(pos);
                }
            }
        });
    }

    public void copy() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.copy();
                }
            }
        });
    }

    public void cut() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.cut();
                }
            }
        });
    }

    public void paste() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.paste();
                }
            }
        });
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        this.caret = caret;
    }

    public void replaceSelection(String content) {
        this.setText(this.getText() + content);
    }

    public void select(final int selectionStart, final int selectionEnd) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.setSelection(selectionStart, selectionEnd);
                }
            }
        });
    }

    public void selectAll() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    JTextComponent.this.ppeer.selectAll();
                }
            }
        });
    }

    public void setSelectionStart(int start) {
        this.selStart = start;
        if (this.selStart > 0 && this.selEnd > 0) {
            this.select(this.selStart, this.selEnd);
        }
    }

    public void setSelectionEnd(int end) {
        this.selEnd = end;
        if (this.selStart > 0 && this.selEnd > 0) {
            this.select(this.selStart, this.selEnd);
        }
    }

    private void refreshCachedSelection() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTextComponent.this.ppeer)) {
                    Point point = JTextComponent.this.ppeer.getSelection();
                    JTextComponent.this.selStart = point.x;
                    JTextComponent.this.selEnd = point.y;
                }
            }
        });
    }

    public int getSelectionStart() {
        this.refreshCachedSelection();
        return this.selStart;
    }

    public int getSelectionEnd() {
        this.refreshCachedSelection();
        return this.selEnd;
    }

    public void setSelectedTextColor(Color c) {
    }

    public void setSelectionColor(Color c) {
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.ppeer = new Text(parent.getComposite(), 2052);
        this.ppeer.setText(this.pText);
        this.ppeer.setEditable(this.pEditable);
        this.peer = this.ppeer;
        this.parent = parent;
        this.ppeer.addVerifyListener((VerifyListener)new TextEventHandler());
    }

    public void addInputMethodListener() {
    }

    protected class TextEventHandler
    implements VerifyListener {
        public void verifyText(VerifyEvent event) {
            block14: {
                if (JTextComponent.this.doc instanceof AbstractDocument) {
                    AbstractDocument document = (AbstractDocument)JTextComponent.this.doc;
                    DocumentFilter filter = document.getDocumentFilter();
                    event.doit = true;
                    if (filter != null) {
                        if (event.start == event.end) {
                            try {
                                int perfectInsertLength = document.getLength() + event.text.length();
                                document.insertString(event.start, event.text, null);
                                int insertDiff = perfectInsertLength - document.getLength();
                                if (insertDiff == 0) {
                                    int lastIndex = event.start + event.text.length();
                                    if (lastIndex <= document.getLength()) {
                                        event.text = document.getText(0, document.getLength()).substring(event.start, lastIndex);
                                    } else {
                                        event.doit = false;
                                    }
                                    break block14;
                                }
                                event.doit = false;
                            }
                            catch (BadLocationException e) {
                                event.doit = false;
                            }
                        } else {
                            try {
                                int perfectInsertLength = document.getLength() - (event.end - event.start) + event.text.length();
                                document.remove(event.start, event.end - event.start);
                                document.insertString(event.start, event.text, null);
                                int insertDiff = perfectInsertLength - document.getLength();
                                if (insertDiff > 0) {
                                    event.end -= insertDiff;
                                    event.text = document.getText(0, document.getLength()).substring(event.start, event.end);
                                } else if (insertDiff < 0) {
                                    event.doit = false;
                                }
                            }
                            catch (BadLocationException e) {
                                event.doit = false;
                            }
                        }
                    }
                }
            }
        }
    }
}

