/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Vector;
import swingwtx.swing.JComponent;
import swingwtx.swing.JList;
import swingwtx.swing.JTable;
import swingwtx.swing.ListSelectionModel;
import swingwtx.swing.event.ListSelectionEvent;
import swingwtx.swing.event.ListSelectionListener;

public class DefaultListSelectionModel
implements ListSelectionModel {
    protected JComponent component = null;
    protected JTable table = null;
    protected JList list = null;
    protected boolean isTable = true;
    protected Vector listeners = new Vector();
    protected int index0 = -1;
    protected int index1 = -1;
    protected int mode = 0;
    protected boolean isAdjusting = false;

    public DefaultListSelectionModel() {
    }

    protected DefaultListSelectionModel(JComponent component) {
        this.component = component;
        this.isTable = component instanceof JTable;
        if (this.isTable) {
            this.table = (JTable)component;
        } else {
            this.list = (JList)component;
        }
    }

    public void addListSelectionListener(ListSelectionListener x) {
        this.listeners.add(x);
    }

    public void addSelectionInterval(int index0, int index1) {
        this.setSelectionInterval(index0, index1);
    }

    public void clearSelection() {
        if (this.isTable) {
            this.table.clearSelection();
        } else {
            this.list.clearSelection();
        }
    }

    public int getAnchorSelectionIndex() {
        return this.index0;
    }

    public int getLeadSelectionIndex() {
        return this.index1;
    }

    public int getMaxSelectionIndex() {
        return this.index1;
    }

    public int getMinSelectionIndex() {
        return this.index0;
    }

    public int getSelectionMode() {
        return this.mode;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void insertIndexInterval(int index, int length, boolean before) {
    }

    public boolean isSelectedIndex(int index) {
        return index >= this.index0 && index <= this.index1;
    }

    public boolean isSelectionEmpty() {
        return this.index0 == -1 && this.index1 == -1;
    }

    public void removeIndexInterval(int index0, int index1) {
        index0 = -1;
        index1 = -1;
    }

    public void removeListSelectionListener(ListSelectionListener x) {
        this.listeners.remove(x);
    }

    public void removeSelectionInterval(int index0, int index1) {
        index0 = -1;
        index1 = -1;
    }

    public void setAnchorSelectionIndex(int index) {
        this.index0 = index;
        this.updateComponentForSelection();
    }

    public void setLeadSelectionIndex(int index) {
        this.index1 = index;
        this.updateComponentForSelection();
    }

    public void setSelectionInterval(int index0, int index1) {
        this.index0 = index0;
        this.index1 = index1;
        this.updateComponentForSelection();
    }

    public void setSelectionMode(int selectionMode) {
        this.mode = selectionMode;
        if (this.isTable) {
            this.table.setModelDirty(true);
            this.table.refreshTable();
        }
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.isAdjusting = valueIsAdjusting;
    }

    protected void updateComponentForSelection() {
        if (this.isTable) {
            if (this.mode == 2) {
                for (int i = this.index0; i <= this.index1; ++i) {
                    this.table.changeSelection(i, 0, true, false);
                }
            }
        } else if (this.mode == 2) {
            int[] s = new int[this.index1 - this.index0 + 1];
            for (int i = 0; i < s.length; ++i) {
                s[i] = this.index0 + 1;
            }
            this.list.setSelectedIndices(s);
        }
    }

    void fireListSelectionEvent(Object source, int index0, int index1) {
        this.index0 = index0;
        this.index1 = index1;
        if (this.listeners.size() == 0) {
            return;
        }
        ListSelectionEvent e = new ListSelectionEvent(source, index0, index1, false);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListSelectionListener)this.listeners.get(i)).valueChanged(e);
        }
    }
}

