/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class WorkbenchThemeManager
implements IThemeManager {
    private IThemeRegistry themeRegistry;
    private static WorkbenchThemeManager instance;
    private IPropertyChangeListener currentThemeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            WorkbenchThemeManager.this.firePropertyChange(event);
        }
    };
    private Map themes = new HashMap(7);
    private ITheme currentTheme;
    private ListenerList propertyChangeListeners = new ListenerList();

    private WorkbenchThemeManager() {
        Display display = Display.getDefault();
        if (display != null) {
            display.disposeExec(new Runnable(){

                public void run() {
                    WorkbenchThemeManager.this.dispose();
                }
            });
        }
    }

    public static WorkbenchThemeManager getInstance() {
        if (instance == null) {
            instance = new WorkbenchThemeManager();
        }
        return instance;
    }

    public void dispose() {
        Iterator i = this.themes.values().iterator();
        while (i.hasNext()) {
            ITheme theme = (ITheme)i.next();
            theme.removePropertyChangeListener(this.currentThemeListener);
            theme.dispose();
        }
        this.themes.clear();
    }

    private IThemeRegistry getThemeRegistry() {
        if (this.themeRegistry == null) {
            this.themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        }
        return this.themeRegistry;
    }

    public ITheme getTheme(String id) {
        IThemeDescriptor td = id == null ? null : this.getThemeRegistry().findTheme(id);
        return this.getTheme(td);
    }

    private ITheme getTheme(IThemeDescriptor td) {
        ITheme theme = (ITheme)this.themes.get(td);
        if (theme == null) {
            theme = new Theme(td);
            this.themes.put(td, theme);
        }
        return theme;
    }

    public ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            String themeId = PlatformUI.getWorkbench().getPreferenceStore().getString("CURRENT_THEME_ID");
            if (themeId.equals("")) {
                themeId = IThemeManager.DEFAULT_THEME;
            }
            this.setCurrentTheme(themeId);
        }
        return this.currentTheme;
    }

    public void setCurrentTheme(String id) {
        ITheme oldTheme = this.currentTheme;
        if (WorkbenchThemeManager.getInstance().doSetCurrentTheme(id)) {
            this.firePropertyChange("CHANGE_CURRENT_THEME", oldTheme, this.getCurrentTheme());
            if (oldTheme != null) {
                oldTheme.removePropertyChangeListener(this.currentThemeListener);
            }
            this.currentTheme.addPropertyChangeListener(this.currentThemeListener);
            PlatformUI.getWorkbench().getPreferenceStore().setValue("CURRENT_THEME_ID", id == null ? "" : id);
        }
    }

    private boolean doSetCurrentTheme(String id) {
        ITheme oldTheme = this.currentTheme;
        ITheme newTheme = this.getTheme(id);
        if (oldTheme != newTheme) {
            this.currentTheme = newTheme;
            return true;
        }
        return false;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    protected void firePropertyChange(String changeId, ITheme oldTheme, ITheme newTheme) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, (Object)oldTheme, (Object)newTheme);
        this.firePropertyChange(event);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }
}

