/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.registry.ViewRegistry;

public class ViewRegistryReader
extends RegistryReader {
    private static final String TAG_VIEW = "view";
    private static final String TAG_CATEGORY = "category";
    private ViewRegistry viewRegistry;

    protected void readCategory(IConfigurationElement element) {
        try {
            Category category = new Category(element);
            this.viewRegistry.add(category);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create view category.", e.getStatus());
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_VIEW)) {
            this.readView(element);
            return true;
        }
        if (element.getName().equals(TAG_CATEGORY)) {
            this.readCategory(element);
            this.readElementChildren(element);
            return true;
        }
        return false;
    }

    protected void readView(IConfigurationElement element) {
        try {
            String descText = this.getDescription(element);
            ViewDescriptor desc = new ViewDescriptor(element, descText);
            this.viewRegistry.add(desc);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create view descriptor.", e.getStatus());
        }
    }

    public void readViews(IExtensionRegistry in, ViewRegistry out) throws CoreException {
        this.viewRegistry = out;
        this.readRegistry(in, "org.eclipse.ui", "views");
        out.mapViewsToCategories();
    }
}

