/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressViewer;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewerLabelProvider;

public class ProgressRegion {
    ProgressViewer viewer;
    AnimationItem item;
    Composite region;
    WorkbenchWindow workbenchWindow;

    public Control createContents(Composite parent, WorkbenchWindow window) {
        this.workbenchWindow = window;
        this.region = new Composite(parent, 0);
        FormLayout regionLayout = new FormLayout();
        this.region.setLayout((Layout)regionLayout);
        Label seperator = new Label(this.region, 2);
        this.item = new ProgressAnimationItem(window);
        this.item.createControl(this.region);
        Control itemControl = this.item.getControl();
        this.viewer = new ProgressViewer(this.region, 524288, 1, 36);
        this.viewer.setUseHashlookup(true);
        Control viewerControl = this.viewer.getControl();
        int widthPreference = AnimationManager.getInstance().getPreferredWidth();
        Point preferredSize = this.viewer.getSizeHints();
        int margin = 2;
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, margin);
        labelData.top = new FormAttachment(0);
        seperator.setLayoutData((Object)labelData);
        FormData itemData = new FormData();
        itemData.right = new FormAttachment(100, -1 * margin);
        itemData.top = new FormAttachment(viewerControl, margin, 128);
        itemData.width = widthPreference + margin * 2;
        itemData.height = preferredSize.y;
        itemControl.setLayoutData((Object)itemData);
        FormData viewerData = new FormData();
        viewerData.left = new FormAttachment((Control)seperator, margin);
        viewerData.right = new FormAttachment(itemControl, margin);
        viewerData.top = new FormAttachment(0);
        viewerData.bottom = new FormAttachment(100);
        viewerData.width = preferredSize.x + margin;
        viewerData.height = preferredSize.y;
        viewerControl.setLayoutData((Object)viewerData);
        viewerControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProgressManagerUtil.openProgressView(ProgressRegion.this.workbenchWindow);
            }
        });
        viewerControl.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseHover(MouseEvent e) {
                ProgressRegion.this.item.openFloatingWindow();
            }
        });
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressViewerLabelProvider(viewerControl));
        this.viewer.setSorter(ProgressManagerUtil.getProgressViewerSorter());
        return this.region;
    }

    public AnimationItem getAnimationItem() {
        return this.item;
    }

    public Control getControl() {
        return this.region;
    }
}

