/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.CommandManagerFactory;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.NoSuchAttributeException;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.handlers.HandlerProxy;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.commands.CommandManager;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeyFormatterFactory;
import org.eclipse.ui.keys.SWTKeySupport;

public class WorkbenchCommandSupport
implements IWorkbenchCommandSupport {
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private Listener activationListener = new Listener(){

        public void handleEvent(Event event) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false, event.display.getActiveShell());
        }
    };
    private Shell activeShell;
    private IWorkbenchSite activeWorkbenchSite;
    private IWorkbenchWindow activeWorkbenchWindow;
    private Map handlerSubmissionsByCommandId = new HashMap();
    private ICommandManager mutableCommandManager;
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage workbenchPage) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void pageClosed(IWorkbenchPage workbenchPage) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void pageOpened(IWorkbenchPage workbenchPage) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void perspectiveChanged(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor, String changeId) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }
    };
    private Workbench workbench;
    static /* synthetic */ Class class$0;

    public WorkbenchCommandSupport(Workbench workbenchToSupport) {
        this.workbench = workbenchToSupport;
        this.mutableCommandManager = CommandManagerFactory.getCommandManager();
        KeyFormatterFactory.setDefault(SWTKeySupport.getKeyFormatterForPlatform());
        workbenchToSupport.getDisplay().addFilter(26, this.activationListener);
        if (this.mutableCommandManager instanceof CommandManager) {
            ArrayList<HandlerSubmission> submissions = new ArrayList<HandlerSubmission>();
            CommandManager commandManager = (CommandManager)this.mutableCommandManager;
            Set handlers = commandManager.getDefinedHandlers();
            Iterator handlerItr = handlers.iterator();
            while (handlerItr.hasNext()) {
                HandlerProxy proxy = (HandlerProxy)handlerItr.next();
                try {
                    String commandId = (String)proxy.getAttributeValue("id");
                    Integer priority = (Integer)proxy.getAttributeValue("priority");
                    HandlerSubmission submission = new HandlerSubmission(null, null, commandId, proxy, priority);
                    submissions.add(submission);
                }
                catch (NoSuchAttributeException noSuchAttributeException) {}
            }
            if (!submissions.isEmpty()) {
                this.addHandlerSubmissions(submissions);
            }
        }
    }

    public void addHandlerSubmissions(List handlerSubmissions) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.HandlerSubmission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        handlerSubmissions = Util.safeCopy(handlerSubmissions, (Class)clazz);
        Iterator iterator = handlerSubmissions.iterator();
        while (iterator.hasNext()) {
            HandlerSubmission handlerSubmission = (HandlerSubmission)iterator.next();
            String commandId = handlerSubmission.getCommandId();
            ArrayList<HandlerSubmission> handlerSubmissions2 = (ArrayList<HandlerSubmission>)this.handlerSubmissionsByCommandId.get(commandId);
            if (handlerSubmissions2 == null) {
                handlerSubmissions2 = new ArrayList<HandlerSubmission>();
                this.handlerSubmissionsByCommandId.put(commandId, handlerSubmissions2);
            }
            handlerSubmissions2.add(handlerSubmission);
        }
        this.processHandlerSubmissions(true);
    }

    public void deregisterFromKeyBindings(Shell shell) {
        IWorkbenchContextSupport contextSupport = this.workbench.getContextSupport();
        contextSupport.unregisterShell(shell);
    }

    public ICommandManager getCommandManager() {
        return this.mutableCommandManager;
    }

    public final boolean isKeyFilterEnabled() {
        return this.workbench.getContextSupport().isKeyFilterEnabled();
    }

    private void processHandlerSubmissions(boolean force) {
        this.processHandlerSubmissions(force, this.workbench.getDisplay().getActiveShell());
    }

    public void processHandlerSubmissions(boolean force, Shell newActiveShell) {
        IWorkbenchPartSite newWorkbenchSite = null;
        IWorkbenchWindow newWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        boolean update = false;
        if (this.activeShell != newActiveShell) {
            this.activeShell = newActiveShell;
            update = true;
        }
        if (this.activeWorkbenchWindow != newWorkbenchWindow) {
            if (this.activeWorkbenchWindow != null) {
                this.activeWorkbenchWindow.removePageListener(this.pageListener);
                this.activeWorkbenchWindow.removePerspectiveListener(this.perspectiveListener);
                this.activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
            }
            if (newWorkbenchWindow != null) {
                newWorkbenchWindow.addPageListener(this.pageListener);
                newWorkbenchWindow.addPerspectiveListener(this.perspectiveListener);
                newWorkbenchWindow.getPartService().addPartListener(this.partListener);
            }
            this.activeWorkbenchWindow = newWorkbenchWindow;
            update = true;
        }
        if (newWorkbenchWindow != null && newWorkbenchWindow.getShell().equals(newActiveShell)) {
            IWorkbenchPart activeWorkbenchPart;
            IWorkbenchPage activeWorkbenchPage = newWorkbenchWindow.getActivePage();
            if (activeWorkbenchPage != null && (activeWorkbenchPart = activeWorkbenchPage.getActivePart()) != null) {
                newWorkbenchSite = activeWorkbenchPart.getSite();
            }
        } else {
            newWorkbenchSite = null;
        }
        if (force || update || !Util.equals(this.activeWorkbenchSite, newWorkbenchSite)) {
            this.activeWorkbenchSite = newWorkbenchSite;
            HashMap<String, IHandler> handlersByCommandId = new HashMap<String, IHandler>();
            Iterator iterator = this.handlerSubmissionsByCommandId.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String commandId = (String)entry.getKey();
                List handlerSubmissions = (List)entry.getValue();
                Iterator submissionItr = handlerSubmissions.iterator();
                HandlerSubmission bestHandlerSubmission = null;
                boolean conflict = false;
                while (submissionItr.hasNext()) {
                    Shell activeShell2;
                    IWorkbenchWindow activeWorkbenchWindow2;
                    HandlerSubmission handlerSubmission = (HandlerSubmission)submissionItr.next();
                    IWorkbenchSite activeWorkbenchSite2 = handlerSubmission.getActiveWorkbenchSite();
                    if (activeWorkbenchSite2 != null && activeWorkbenchSite2 != newWorkbenchSite || (activeWorkbenchWindow2 = handlerSubmission.getActiveWorkbenchWindow()) != null && (activeWorkbenchWindow2 != newWorkbenchWindow || activeWorkbenchWindow2.getShell() != this.activeShell) || (activeShell2 = handlerSubmission.getActiveShell()) != null && activeShell2 != this.activeShell) continue;
                    if (bestHandlerSubmission == null) {
                        bestHandlerSubmission = handlerSubmission;
                        continue;
                    }
                    int compareTo = Util.compare(activeWorkbenchSite2, bestHandlerSubmission.getActiveWorkbenchSite());
                    if (compareTo == 0) {
                        compareTo = Util.compare(activeWorkbenchWindow2, bestHandlerSubmission.getActiveWorkbenchWindow());
                        if (compareTo == 0) {
                            compareTo = Util.compare(activeShell2, bestHandlerSubmission.getActiveShell());
                        }
                        if (compareTo == 0) {
                            compareTo = Util.compare(-handlerSubmission.getPriority(), -bestHandlerSubmission.getPriority());
                        }
                    }
                    if (compareTo > 0) {
                        if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                            System.out.println("HANDLERS >>> Resolved conflict detected for " + bestHandlerSubmission);
                        }
                        conflict = false;
                        bestHandlerSubmission = handlerSubmission;
                        continue;
                    }
                    if (compareTo == 0 && bestHandlerSubmission.getHandler() != handlerSubmission.getHandler()) {
                        if (DEBUG) {
                            System.out.println("HANDLERS >>> Unresolved conflict detected for " + commandId);
                        }
                        conflict = true;
                        continue;
                    }
                    if (!DEBUG_VERBOSE || DEBUG_VERBOSE_COMMAND_ID != null && !DEBUG_VERBOSE_COMMAND_ID.equals(commandId)) continue;
                    System.out.println("HANDLERS >>> Resolved conflict detected for " + bestHandlerSubmission);
                }
                if (bestHandlerSubmission == null || conflict) continue;
                handlersByCommandId.put(commandId, bestHandlerSubmission.getHandler());
            }
            ((CommandManager)this.mutableCommandManager).setHandlersByCommandId(handlersByCommandId);
        }
    }

    public void registerForKeyBindings(Shell shell, boolean dialogOnly) {
        IWorkbenchContextSupport contextSupport = this.workbench.getContextSupport();
        if (dialogOnly) {
            contextSupport.registerShell(shell, 0);
        } else {
            contextSupport.registerShell(shell, 2);
        }
    }

    public void removeHandlerSubmissions(List handlerSubmissions) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.HandlerSubmission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        handlerSubmissions = Util.safeCopy(handlerSubmissions, (Class)clazz);
        Iterator iterator = handlerSubmissions.iterator();
        while (iterator.hasNext()) {
            HandlerSubmission handlerSubmission = (HandlerSubmission)iterator.next();
            String commandId = handlerSubmission.getCommandId();
            List handlerSubmissions2 = (List)this.handlerSubmissionsByCommandId.get(commandId);
            if (handlerSubmissions2 == null) continue;
            handlerSubmissions2.remove(handlerSubmission);
            if (!handlerSubmissions2.isEmpty()) continue;
            this.handlerSubmissionsByCommandId.remove(commandId);
        }
        this.processHandlerSubmissions(true);
    }

    public final void setKeyFilterEnabled(boolean keyFilterEnabled) {
        this.workbench.getContextSupport().setKeyFilterEnabled(keyFilterEnabled);
    }
}

