/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PresentableEditorPart;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.presentations.IPresentablePart;

public class EditorPane
extends PartPane {
    private PresentableEditorPart presentableAdapter = new PresentableEditorPart(this);
    private EditorWorkbook workbook;

    public EditorPane(IEditorReference ref, WorkbenchPage page, EditorWorkbook workbook) {
        super(ref, page);
        this.workbook = workbook;
    }

    protected WorkbenchPart createErrorPart(WorkbenchPart oldPart) {
        IEditorPart oldEditorPart = (IEditorPart)((Object)oldPart);
        EditorSite oldEditorSite = (EditorSite)oldEditorPart.getEditorSite();
        class ErrorEditorPart
        extends EditorPart {
            private Text text;
            final /* synthetic */ EditorPane this$0;

            ErrorEditorPart(EditorPane editorPane) {
                this.this$0 = editorPane;
            }

            public void doSave(IProgressMonitor monitor) {
            }

            public void doSaveAs() {
            }

            public void init(IEditorSite site, IEditorInput input) {
                this.setSite(site);
                this.setInput(input);
            }

            public boolean isDirty() {
                return false;
            }

            public boolean isSaveAsAllowed() {
                return false;
            }

            public void createPartControl(Composite parent) {
                this.text = new Text(parent, 74);
                this.text.setForeground(JFaceColors.getErrorText((Display)this.text.getDisplay()));
                this.text.setBackground(this.text.getDisplay().getSystemColor(22));
                this.text.setText(WorkbenchMessages.getString("EditorPane.errorMessage"));
            }

            public void setFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                }
            }

            protected void setTitle(String title) {
                super.setTitle(title);
            }

            protected void setTitleToolTip(String text) {
                super.setTitleToolTip(text);
            }
        }
        ErrorEditorPart newPart = new ErrorEditorPart(this);
        newPart.setTitle(oldPart.getTitle());
        newPart.setTitleToolTip(oldPart.getTitleToolTip());
        oldEditorSite.setPart(newPart);
        newPart.init(oldEditorSite, oldEditorPart.getEditorInput());
        return newPart;
    }

    protected void createTitleBar() {
    }

    public void doHide() {
        this.getPage().closeEditor(this.getEditorReference(), true);
    }

    public void doHideOthers() {
        IEditorReference editor = this.getEditorReference();
        IEditorReference[] allEditors = this.getPage().getEditorReferences();
        IEditorReference[] otherEditors = new IEditorReference[allEditors.length - 1];
        int j = 0;
        int i = 0;
        while (i < allEditors.length) {
            IEditorReference reference = allEditors[i];
            if (!reference.equals(editor) && j < otherEditors.length) {
                otherEditors[j++] = reference;
            }
            ++i;
        }
        this.getPage().closeEditors(otherEditors, true);
    }

    public void doHideAll() {
        this.getPage().closeEditors(this.getPage().getEditorReferences(), true);
    }

    public IEditorReference getEditorReference() {
        return (IEditorReference)this.getPartReference();
    }

    int getStyle() {
        return 0;
    }

    public EditorWorkbook getWorkbook() {
        return this.workbook;
    }

    public boolean isDragAllowed(Point p) {
        if (this.workbook.isDragAllowed(p)) {
            return false;
        }
        int wbCount = this.workbook.getEditorArea().getEditorWorkbookCount();
        int editorCount = this.workbook.getItemCount();
        if (this.isZoomed()) {
            return editorCount > 1;
        }
        return editorCount > 1 || wbCount > 1;
    }

    protected void requestActivation() {
        if (!this.workbook.isActiveWorkbook()) {
            this.workbook.getEditorArea().setActiveWorkbook(null, false);
        }
        super.requestActivation();
    }

    public void setWorkbook(EditorWorkbook editorWorkbook) {
        this.workbook = editorWorkbook;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    public void showFocus(boolean inFocus) {
        if (inFocus) {
            this.workbook.becomeActiveWorkbook(true);
        } else {
            this.workbook.tabFocusHide();
        }
    }

    protected void addCloseOthersItem(Menu menu) {
        MenuItem item = new MenuItem(menu, 0);
        item.setText(WorkbenchMessages.getString("PartPane.closeOthers"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPane.this.doHideOthers();
            }
        });
        item.setEnabled(this.getPage().getEditors().length > 1);
    }

    protected void addCloseAllItem(Menu menu) {
        MenuItem item = new MenuItem(menu, 0);
        item.setText(WorkbenchMessages.getString("PartPane.closeAll"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPane.this.doHideAll();
            }
        });
        item.setEnabled(this.getPage().getEditors().length >= 1);
    }

    protected void addMoveItems(Menu moveMenu) {
        int wbCount = this.workbook.getEditorArea().getEditorWorkbookCount();
        int editorCount = this.workbook.getItemCount();
        MenuItem item = new MenuItem(moveMenu, 0);
        item.setText(WorkbenchMessages.getString("EditorPane.moveEditor"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPane.this.workbook.openTracker(EditorPane.this);
            }
        });
        if (this.isZoomed()) {
            item.setEnabled(editorCount > 1);
        } else {
            item.setEnabled(editorCount > 1 || wbCount > 1);
        }
        item = new MenuItem(moveMenu, 0);
        item.setText(WorkbenchMessages.getString("EditorPane.moveFolder"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPane.this.workbook.openTracker(EditorPane.this.getWorkbook());
            }
        });
        if (this.isZoomed()) {
            item.setEnabled(false);
        } else {
            item.setEnabled(wbCount > 1);
        }
    }

    protected void addPinEditorItem(Menu parent) {
        boolean reuseEditor = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!reuseEditor) {
            return;
        }
        IWorkbenchPart part = this.getPartReference().getPart(false);
        if (part == null) {
            return;
        }
        final MenuItem item = new MenuItem(parent, 32);
        item.setText(WorkbenchMessages.getString("EditorPane.pinEditor"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPart part = EditorPane.this.getPartReference().getPart(true);
                if (part == null) {
                    item.setSelection(false);
                    item.setEnabled(false);
                } else {
                    ((EditorSite)part.getSite()).setReuseEditor(!item.getSelection());
                }
            }
        });
        item.setEnabled(true);
        item.setSelection(!((EditorSite)part.getSite()).getReuseEditor());
    }

    protected PartPane.Sashes findSashes() {
        PartPane.Sashes result = new PartPane.Sashes();
        this.workbook.getEditorArea().findSashes(this.workbook, result);
        return result;
    }

    public void updateTitles() {
    }

    public void showPaneMenu() {
        ILayoutContainer container = this.getContainer();
        if (container instanceof EditorWorkbook) {
            EditorWorkbook folder = (EditorWorkbook)container;
            folder.showSystemMenu();
        }
    }

    public void showViewMenu() {
    }

    public IPresentablePart getPresentablePart() {
        return this.presentableAdapter;
    }
}

